# Transport — Tenerife

## Overview

Tenerife's public transport is decent but car-centric island means driving offers more freedom.

| Mode | Coverage | Cost | Best For |
|------|----------|------|----------|
| Bus (Guagua) | Good on main routes | € | Budget, main routes |
| Tram | Santa Cruz ↔ La Laguna | € | North commute |
| Taxi | Available | €€ | Short trips, groups |
| Rental Car | Everywhere | €€-€€€ | Exploration |
| Own Car | Everywhere | €€€ | Residents |

---

## Bus (TITSA)

### Network
- Main operator: TITSA (Transportes Interurbanos de Tenerife)
- Covers most towns and tourist areas
- Color-coded by area
- Website: titsa.com (schedules, routes)

### Key Routes

| Route | From/To | Frequency |
|-------|---------|-----------|
| 111 | Costa Adeje – Los Cristianos – Airport | Frequent |
| 110 | Santa Cruz – Airport South | Every 30 min |
| 101 | Santa Cruz – Puerto de la Cruz | Every 20-30 min |
| 102 | Santa Cruz – La Laguna | Frequent |
| 015 | Los Cristianos – Teide | 1-2 daily |

### Fares
- Single rides: €1.35-9.00 depending on distance
- TenMas card: 30% discount, rechargeable
- Day/week passes: Available

### TenMas Card
- Buy at bus stations, some shops
- Load credit
- 30-50% savings vs cash
- Valid on buses and tram
- Essential for regular users

### Tips
- Exact change not required (drivers give change)
- Front door entry, middle door exit
- Tell driver your destination
- Running late is common
- Night service limited

---

## Tram (Tranvía)

### Route
- Line 1: Santa Cruz ↔ La Laguna (30 minutes)
- Modern, clean, reliable
- Every 5-10 minutes

### Useful Stops
- Intercambiador (Santa Cruz): Bus connections
- Teatro Guimerá: Downtown Santa Cruz
- Trinidad: La Laguna center
- Padre Anchieta: La Laguna (end)

### Fares
- Single: €1.35
- TenMas discount: €0.89
- Combined bus/tram possible

---

## Taxi

### Availability
- Available at ranks in towns
- Can be hailed
- Booking by phone/app

### Apps & Numbers
- PideTaxi app (works islandwide)
- Radio Taxi: 922 64 00 00
- Taxi Santa Cruz: 922 21 11 11

### Approximate Fares

| Route | Cost |
|-------|------|
| Within town | €5-12 |
| Airport South → Los Cristianos | €25-35 |
| Airport South → Costa Adeje | €35-45 |
| Santa Cruz → La Laguna | €15-20 |
| Costa Adeje → Teide (day trip) | €100-150 |

### Tips
- Meters used (taxímetro)
- Fixed rates to airport (ask)
- Night/weekend supplement
- Luggage supplement possible
- Tipping: Round up

---

## Rental Cars

### Why Rent
- Freedom to explore
- Public transport limited rurally
- Essential for Anaga, Teide, beaches
- Relatively affordable

### Companies

**Local (Often Best)**
- Cicar (recommended, islandwide)
- TopCar
- AutoReisen
- Plus Car

**International**
- Hertz, Europcar, Avis
- Usually more expensive
- Airport convenience

### Prices
- Low season: €15-25/day
- High season: €25-45/day
- Monthly: €300-600
- Book ahead online for best rates

### What to Know
- Manual transmission default
- Automatic available (costs more)
- Diesel common and cheaper
- Full insurance recommended
- CDW/excess waiver: Worth it for mountain roads

### Pickup
- **Airport**: Most convenient, desk or shuttle
- **Town offices**: Sometimes cheaper
- Return full: Standard policy

### Driving License
- EU licenses: Valid
- Non-EU: International permit recommended (+ home license)
- UK post-Brexit: Valid for visits, exchange for Spanish if resident

---

## Owning a Car

### For Residents

**Buying**
- New: Dealerships everywhere
- Used: Coches.net, Milanuncios, local dealers
- Import: Possible but complex

**Registration**
- ITV (inspection) equivalent required
- Matriculación (registration)
- Insurance mandatory
- Impuesto de circulación (road tax) annually

**Costs**
| Item | Cost |
|------|------|
| Small used car | €3,000-10,000 |
| Insurance | €300-600/year |
| Road tax | €50-150/year |
| ITV | €35-50/year |
| Fuel | €1.40-1.60/L (cheaper than mainland) |

### Tips
- Second-hand market active
- Many ex-rental cars available
- Check for rust (sea air)
- Get pre-purchase inspection

---

## Driving Tips

### General
- Drive on right
- Seat belts mandatory
- Phone use: Hands-free only
- Drink driving: Strict (0.25mg/L breath limit)
- Speed cameras: Common
- Fines arrive by post (even months later)

### Mountain Roads
- Winding but well-maintained
- Use low gears downhill
- Honk on blind curves (some have mirrors)
- Allow extra time (30km can take 1h)
- Vertigo-inducing in places

### Parking
- White lines: Free
- Blue lines: Paid (ORA)
- Yellow lines: No parking
- Underground: €1-2/hour
- Free lots outside town centers

### Fuel
- Cheaper than mainland Spain
- Diesel more common
- Full-service and self-service
- Card usually accepted

### Speed Limits
| Road | Limit |
|------|-------|
| Urban | 30-50 km/h |
| Secondary | 90 km/h |
| Highway (TF-1, TF-5) | 120 km/h |

---

## Inter-Island Transport

### Ferries

**Operators**
- Fred Olsen: Faster, more expensive
- Naviera Armas: Slower, cheaper

**Routes from Tenerife**
| Destination | Departs | Time | Price |
|-------------|---------|------|-------|
| La Gomera | Los Cristianos | 50 min (Fred Olsen) | €35-45 |
| La Palma | Los Cristianos | 2.5h | €40-60 |
| El Hierro | Via La Gomera | 4h+ | €50-70 |
| Gran Canaria | Santa Cruz | 2-4h | €40-60 |

**Booking**
- Online: fredolsen.es, navieraarmas.com
- Discounts: Residents get 75% off
- Cars: Can take, add €30-80

### Flights

**Airlines**
- Binter: Main inter-island
- Canaryfly: Budget option

**Routes**
- Tenerife North (TFN) to all islands
- 20-45 minute flights
- €40-100 roundtrip
- Resident discount 75%

---

## Getting From Airports

### Tenerife South (TFS)

| Destination | Method | Time | Cost |
|-------------|--------|------|------|
| Costa Adeje | Bus 111 | 30 min | €4 |
| Los Cristianos | Bus 111 | 25 min | €3.50 |
| El Médano | Taxi | 15 min | €15-20 |
| Santa Cruz | Bus 111 | 55 min | €9.50 |

### Tenerife North (TFN)

| Destination | Method | Time | Cost |
|-------------|--------|------|------|
| La Laguna | Bus 102/108 | 20 min | €2.50 |
| Santa Cruz | Bus 102 | 30 min | €2.50 |
| Puerto Cruz | Bus 102+101 | 50 min | €5 |

### Tips
- TenMas card works on airport buses
- Taxis have fixed airport rates
- Pre-book transfers for convenience
- Rental car pickup at both airports
