# Tax & ZEC Benefits — Tenerife

## Canary Islands Tax Advantages

The Canary Islands have special tax status within Spain and the EU, creating legitimate advantages.

---

## ZEC (Zona Especial Canaria)

### What Is It
A low-tax zone for businesses operating in the Canary Islands.

### Key Benefit
**4% corporate tax** (vs 25% mainland Spain)

### Requirements

**To Qualify**
- Create jobs (minimum 5 in Tenerife/Gran Canaria, 3 in smaller islands)
- Minimum investment (€100,000 in Tenerife/Gran Canaria)
- Business in approved sectors
- Real economic activity in Canarias
- At least one director resident in Canarias

**Eligible Sectors**
- Technology and IT
- Renewable energy
- Audiovisual production
- Call centers
- Industrial manufacturing
- Services (many types)
- Logistics
- R&D

**Excluded Sectors**
- Financial services
- Retail (mostly)
- Real estate
- Professional services (some)

### How It Works
1. Apply through CIDE or ZEC office
2. Approval process (few months)
3. Register company under ZEC regime
4. Comply with requirements
5. File taxes at 4% rate

### Practical Reality
- Good for established businesses
- Not for solo freelancers
- Job creation requirement challenging for small operations
- Worth exploring if scaling up
- Get professional advice

---

## IGIC (Canary Islands VAT)

### The Basics
- **Standard rate**: 7% (vs 21% IVA mainland)
- **Reduced**: 3% (food basics)
- **Zero**: Some essentials
- **Increased**: 13.5% (some goods)

### What This Means
- Consumer goods cheaper
- Services cheaper
- Business costs lower
- Competitive advantage

### For Businesses
- Charge IGIC not IVA
- Different reporting requirements
- Can't reclaim mainland IVA directly
- Customs considerations for imports

---

## Personal Income Tax

### Becoming Tax Resident
You're Spanish tax resident if:
- Spend 183+ days in Spain
- Center of economic interests in Spain
- Family (spouse/kids) live in Spain

### Rates
Progressive system (slightly lower in Canarias):

| Income (€) | Rate |
|------------|------|
| 0 - 12,450 | 18.5% |
| 12,451 - 20,200 | 24% |
| 20,201 - 35,200 | 30% |
| 35,201 - 60,000 | 37% |
| 60,000+ | 47% |

### Working as Employed
- Employer handles tax/social security
- Monthly deductions from salary
- Annual declaration still required

### Self-Employed (Autónomo)

**Social Security**
- Mandatory contribution
- New income-based system (2023+)
- Minimum ~€300/month
- Higher earners pay more

**Income Tax**
- Quarterly estimates (Modelo 130)
- Annual declaration
- Deduct business expenses
- Keep receipts for everything

---

## Digital Nomad Tax Situation

### Common Scenarios

**Scenario 1: Short Stay (<183 days)**
- Not Spanish tax resident
- Pay taxes in home country
- Should still declare correctly there
- Simple approach

**Scenario 2: Full Relocation**
- Become Spanish tax resident
- Register as autónomo or employee
- Pay Spanish taxes
- Complex but proper

**Scenario 3: Spain Digital Nomad Visa**
- Special tax regime possible (Beckham Law)
- 24% flat rate on Spanish-source income
- Complex rules on foreign income
- Professional advice essential

### Beckham Law
- Originally for footballers
- Now applies to some relocated workers
- 24% flat rate (vs progressive)
- 6-year duration
- Specific requirements
- Not automatic — must elect

---

## Business Structures

### Solo Freelancer

**Autónomo (Self-Employed)**
- Simplest for freelancers
- Personal liability
- Quarterly tax filings
- Social security contributions
- Good for testing the waters

**Costs**
- Social security: €300-500/month
- Accountant (gestoría): €50-100/month
- Registration: ~€200

### Company Formation

**Sociedad Limitada (SL)**
- Limited liability
- Minimum €3,000 capital
- More complex setup
- Better for growth

**ZEC Company**
- SL under ZEC regime
- 4% corporate tax
- Job creation required
- More substantial operation

---

## Practical Tax Steps

### For Autónomo

**Setup**
1. Get NIE
2. Register with Tax Agency (Hacienda)
3. Register with Social Security
4. Open business bank account
5. Hire gestoría (accountant)

**Ongoing**
- Monthly social security payment
- Quarterly tax declarations (Modelo 130)
- Annual income tax return
- Keep all receipts/invoices
- Issue proper invoices

### Documents Needed
- NIE
- Passport
- Proof of address
- Business activity description
- Bank account

---

## Common Mistakes

### Don't
- Assume you can work undeclared
- Ignore 183-day rule
- Mix personal and business finances
- Forget quarterly filings
- Throw away receipts

### Do
- Get professional advice early
- Keep meticulous records
- Understand your obligations
- Plan before relocating
- Consider timing of moves

---

## Getting Help

### Gestorías (Tax/Admin Agents)
- Handle filings for you
- €50-150/month typical
- Speak English (ask)
- Essential for non-Spanish speakers

### Tax Advisors (Asesores Fiscales)
- Strategic advice
- International tax planning
- More expensive
- Worth it for complex situations

### Finding Help
- Ask other nomads
- Coworking community recommendations
- Online for remote services
- Interview before committing

---

## Resources

### Official
- Agencia Tributaria: agenciatributaria.es
- ZEC: zec.org
- Social Security: seg-social.es

### Practical
- Gestoría Canarias (various)
- International tax advisors online
- Nomad communities for recommendations

---

## Disclaimer

Tax rules change. This is guidance, not advice. Consult a qualified professional for your specific situation.
