# Safety & Healthcare — Tenerife

## Safety Overview

Tenerife is very safe. Violent crime rare, petty theft exists but lower than most European destinations.

### Crime Reality

**Very Low Risk**
- Violent crime
- Muggings
- Assault
- Serious theft

**Low Risk (Normal Precautions)**
- Pickpocketing (tourist areas)
- Car break-ins
- Rental scams

**Essentially Zero**
- Terrorism
- Gang violence
- Hate crimes

### Standard Precautions

**In Tourist Areas**
- Watch belongings in crowds
- Don't leave valuables in car
- Be aware of surroundings
- Use hotel safes

**Beaches**
- Don't leave belongings unattended
- Watch for riptides (respect flags)
- Secure car parking

**Nightlife**
- Standard night-out awareness
- Las Américas can be rowdy
- Taxi home late at night

---

## Emergency Numbers

| Service | Number |
|---------|--------|
| General emergency | 112 |
| Police (Policía Nacional) | 091 |
| Local police (Policía Local) | 092 |
| Guardia Civil | 062 |
| Medical emergency | 061 |
| Fire | 080 |
| Maritime rescue | 900 202 202 |

### 112 Tips
- English operators available
- GPS location shared automatically
- Works without SIM

---

## Police

### Types of Police

**Policía Nacional**
- National police
- Serious crimes
- Immigration matters
- Blue uniforms

**Guardia Civil**
- Rural areas
- Traffic (highways)
- Green uniforms
- Military origin

**Policía Local**
- Municipal police
- Local issues
- Traffic (towns)
- Blue/varies uniforms

### Reporting Issues
- Police station: Comisaría
- Online reporting: Limited
- Tourist police: Main tourist areas
- English speakers: Usually available

---

## Natural Hazards

### Ocean Safety

**Beach Flags**
| Flag | Meaning |
|------|---------|
| 🟢 Green | Safe to swim |
| 🟡 Yellow | Caution, moderate conditions |
| 🔴 Red | No swimming, dangerous |
| ⚫ Black | Beach closed |

**Dangers**
- Riptides: Especially east coast
- Waves: Can be powerful
- Rocks: Volcanic, sharp
- Jellyfish: Occasional (not dangerous)

### Sun
- UV is strong (altitude + latitude)
- Use SPF50+
- Hydrate constantly
- Take breaks midday

### Mountains

**Hiking Safety**
- Weather changes fast
- Tell someone your route
- Bring water, layers
- Stick to marked trails
- Mobile coverage patchy

**Teide Specific**
- Altitude sickness possible (3,718m)
- Much colder than coast
- Cable car can close for weather
- Summit permit required for final section

### Driving

**Risks**
- Mountain roads (curves, drops)
- Fog (north especially)
- Narrow roads in villages
- Tourist drivers unfamiliar

**Tips**
- Drive defensively
- Use low gears downhill
- Don't rush
- Pull over to let locals pass

---

## Healthcare System

### Public Healthcare (SNS)

**How It Works**
- Centros de Salud (health centers) for GP
- Hospitals for emergencies and specialists
- Pharmacies for common issues

**Access**
- Residents: SIP card, full access
- EU visitors: EHIC/GHIC card
- Others: Emergency only, or pay

**Quality**
- Good overall
- Wait times for specialists
- Emergencies handled quickly
- Language can be barrier

### Getting Care

**Routine Care**
1. Go to assigned Centro de Salud
2. Book appointment (cita previa)
3. See GP (médico de cabecera)
4. Referral to specialist if needed

**Urgent but Not Emergency**
- Urgencias at Centro de Salud
- PAC (Punto de Atención Continuada) after hours
- Hospital urgencias if serious

**Emergency**
- Call 061 or 112
- Go directly to hospital
- Ambulance will transport

### Hospitals

**Public**
| Hospital | Location | Notes |
|----------|----------|-------|
| Hospital Universitario de Canarias | La Laguna | Largest, trauma center |
| Hospital del Norte | Icod | North area |
| Hospital del Sur | Arona | South area |
| Hospital Universitario Nuestra Señora de Candelaria | Santa Cruz | Second largest |

**Private**
| Hospital | Location | Notes |
|----------|----------|-------|
| Hospiten Sur | Los Cristianos | Tourist-focused |
| Hospiten Rambla | Santa Cruz | Central |
| Quirónsalud Costa Adeje | Adeje | Premium |

### Private Healthcare

**Why Use**
- Faster appointments
- English-speaking staff easier
- Specific specialist choice
- Dental and optical

**Insurance Options**
- Asisa: Good value, wide network
- Sanitas: Largest network
- Adeslas: Reliable
- DKV: International focus

**Costs Without Insurance**
| Service | Price |
|---------|-------|
| GP consultation | €40-60 |
| Specialist | €60-100 |
| Basic blood work | €50-100 |
| X-ray | €40-80 |
| MRI | €200-400 |
| ER visit | €150-300 |

---

## Pharmacies (Farmacias)

### Services
- Over-counter medication
- Prescription filling
- Basic health advice
- Some things prescription-free that need Rx elsewhere

### Hours
- Normal: 9:30-13:30, 17:00-20:30
- Some open all day
- 24h rotation: Look for "Farmacia de guardia"
- Check door for nearest open pharmacy

### What You Can Buy
- Pain relief (paracetamol, ibuprofen)
- Cold/flu remedies
- Digestive aids
- Basic antibiotics (some)
- Contraception
- Sunscreen

### Prescription Reality
- Spanish system, some flexibility
- Bring existing medication boxes
- Doctors can prescribe without full consult
- Private prescriptions available

---

## Dental Care

### Public
- Limited coverage
- Extractions and emergencies only
- Children have more coverage

### Private
- Affordable compared to UK/Germany
- Quality varies, get recommendations
- Dental tourism destination

### Costs
| Treatment | Price |
|-----------|-------|
| Cleaning | €40-70 |
| Filling | €50-80 |
| Extraction | €50-100 |
| Crown | €250-450 |
| Implant | €800-1,500 |

---

## Optical Care

### Not Covered Public
- Eye tests
- Glasses
- Contacts

### Private Options
- Opticians everywhere
- General Óptica (chain)
- Independent opticians
- Hospital eye departments

### Costs
| Item | Price |
|------|-------|
| Eye test | €20-40 |
| Basic glasses | €80-150 |
| Quality glasses | €150-400 |
| Contacts (month) | €20-50 |

---

## Mental Health

### Public System
- Available but limited
- Long waits for psychology
- Psychiatry for serious cases

### Private
- Psychologists available
- €50-80 per session
- Some English-speaking

### Resources
- Teléfono de la Esperanza: 717 003 717
- Crisis line: 024
- International support online

---

## Vaccinations

### None Required
- No special vaccines for Tenerife
- Standard EU destination

### Recommended
- Keep tetanus up to date
- Routine vaccines current
- Hepatitis A if rural areas (optional)
