# Moving to Tenerife — Resident Guide

## First Steps

### Essential Documents

**For Everyone**
1. Passport (valid 6+ months)
2. NIE (Número de Identidad de Extranjero) — foreigner ID number
3. Empadronamiento (town hall registration)
4. Bank account (once NIE obtained)
5. Health card (SIP)

**EU/EEA Citizens**
- Right to live and work freely
- Register at foreign office within 90 days
- Get green NIE certificate

**Non-EU Citizens**
- Need visa before arrival
- Various options (see visas.md)
- More documentation required

---

## NIE (Foreigner ID Number)

### What It Is
Your tax/ID number in Spain. Essential for:
- Opening bank account
- Signing rental contract
- Working legally
- Paying taxes
- Utilities in your name
- Buying property/car

### How to Get

**EU Citizens**
1. Book appointment: Sede electrónica (online) or call
2. Go to Oficina de Extranjeros (Santa Cruz or Puerto de la Cruz)
3. Bring:
   - Passport + copy
   - Application form (EX-15)
   - Proof of address or hotel booking
   - Reason for needing NIE
   - Tax stamp (tasa 790-012) — €12
4. Usually same-day or few days

**Non-EU Citizens**
- NIE issued with your visa
- Or apply at Spanish consulate before travel

### Tips
- Book appointment early (slots fill fast)
- Some gestorías (agencies) can help for €50-150
- Bring extra copies of everything

---

## Empadronamiento (Registration)

### What It Is
Registration with your town hall as resident.

### Why You Need It
- Proves residence
- Access to public healthcare
- School enrollment
- Voting (EU citizens)
- Various benefits/discounts
- Required for many processes

### How to Get
1. Visit your Ayuntamiento (town hall)
2. Bring:
   - Passport
   - NIE (if you have it)
   - Proof of address:
     - Rental contract, OR
     - Property deed, OR
     - Landlord authorization + their ID
3. Usually immediate

### Notes
- Update if you move
- Each resident (including children) needs own
- Some landlords reluctant to allow (negotiate)

---

## Banking

### Opening an Account

**Requirements**
- NIE (some banks accept passport temporarily)
- Passport
- Proof of address (empadronamiento or utility bill)
- Initial deposit (varies, often €100-500)

**Main Banks**
| Bank | Pros | Cons |
|------|------|------|
| Sabadell | Online-friendly, English | Branch fees |
| BBVA | Large network | Can be bureaucratic |
| Santander | International | Less flexible |
| CaixaBank | Good ATM network | Traditional |
| ING | Online, no fees | No branches |
| N26/Revolut | Easy opening, no NIE | Not Spanish banks |

### Recommendations
- Start with N26/Revolut for immediate needs
- Open Spanish bank for longer term
- Sabadell often easiest for foreigners

### Without NIE
- Difficult but possible at some banks
- Non-resident account (cuenta no residente)
- Higher fees, more restrictions
- Get NIE ASAP

---

## Finding Housing

### Rental Market Overview

| Area | 1BR | 2BR | Market |
|------|-----|-----|--------|
| La Laguna | €600-900 | €800-1,100 | Competitive |
| Santa Cruz | €650-950 | €900-1,300 | Available |
| Puerto de la Cruz | €650-950 | €850-1,200 | Moderate |
| Costa Adeje | €900-1,400 | €1,200-2,000 | Competitive |
| El Médano | €750-1,100 | €1,000-1,500 | Very competitive |
| Los Cristianos | €700-1,000 | €950-1,400 | Available |

### Where to Search
- **Idealista.com**: Main Spanish portal
- **Fotocasa.es**: Good selection
- **Facebook groups**: "Alquiler Tenerife", "Tenerife Expats"
- **Walking around**: "Se Alquila" signs
- **Local agencies**: Commission 1-2 months rent

### Requirements
- Deposit: 1-2 months (legally max 2)
- Agency fee: Usually 1 month (tenant pays)
- References/payslips: Sometimes required
- NIE: For formal contracts

### Tips
- Visit in person before signing
- Tourist rentals converted to long-term possible
- Negotiate — market varies by season
- Check community fees if buying

### Unfurnished vs Furnished
- Unfurnished more common for locals
- Furnished typical for expats
- Appliances: Often included even "unfurnished"
- Ask specifically what's included

---

## Utilities

### Setting Up

**Electricity (Luz)**
- Provider: Endesa, Naturgy, etc.
- Need: NIE, empadronamiento, bank account
- Deposit may be required
- Budget: €40-80/month typical

**Water (Agua)**
- Local provider (varies by municipality)
- Usually automatic with property
- Budget: €20-40/month

**Gas**
- Not common (most use electric)
- Butane bottles for cooking in some places
- Delivered by trucks

**Internet**
- Providers: Movistar, Vodafone, Orange, Digi
- Fiber widely available in towns
- €30-50/month for fiber
- Installation can take 1-2 weeks

**Mobile**
- Same providers + Digi, Lowi
- €10-25/month typical
- No contract options available

### Tips
- Previous tenant bills can delay transfer
- Keep receipts for any deposits
- Compare internet packages carefully

---

## Healthcare Access

### Public Healthcare (SNS)

**Eligibility**
- Working and paying social security
- Registered unemployed
- Pensioners from EU
- Residents with "convenio especial" (pay in)

**Getting Your Health Card (SIP)**
1. Visit Centro de Salud (health center)
2. Bring: NIE, empadronamiento, social security docs
3. Assigned a GP (médico de cabecera)

**What's Covered**
- GP visits
- Specialist referrals
- Hospital care
- Emergency care
- Prescriptions (small copay)

**EU Citizens**
- EHIC/GHIC covers temporary stays
- Register for Spanish healthcare if resident

### Private Healthcare

**Why Consider**
- Faster appointments
- Choice of specialist
- English-speaking doctors easier
- Dental, optical often not public

**Main Providers**
- Asisa
- Sanitas
- Adeslas
- DKV

**Cost**
€40-150/month depending on age and coverage

### Hospitals

**Public**
- Hospital Universitario de Canarias (La Laguna)
- Hospital del Norte (Icod)
- Hospital del Sur (Arona)

**Private**
- Hospiten (south and north locations)
- Quirónsalud (Costa Adeje)

---

## Schools & Education

### Public Schools
- Free for residents
- Spanish language instruction
- Good quality generally
- Apply at school or Consejería de Educación

### Private Schools
- Various curricula (British, German, American)
- €5,000-12,000/year typical
- English instruction available

**Options**
- British School of Tenerife
- Wingate School
- Colegio Alemán
- Lycée Français

### University
- Universidad de La Laguna
- Public, affordable
- Various programs in Spanish
- Some English options

---

## Getting Settled

### First Week
1. Find temporary accommodation
2. Get SIM card
3. Book NIE appointment
4. Start apartment hunting
5. Open basic bank account (N26/Revolut)

### First Month
1. Get NIE
2. Sign rental contract
3. Set up utilities
4. Empadronamiento
5. Open Spanish bank account

### First 3 Months
1. Register for healthcare
2. Get SIP card
3. Transfer driving license (if needed)
4. Build local connections
5. Establish routines

---

## Common Challenges

### Bureaucracy
- Spanish admin is slow
- Papers needed for papers
- Patience essential
- Gestorías can help (€50-200 per process)

### Language
- Spanish helpful everywhere
- Essential outside tourist areas
- Google Translate helps
- Consider classes

### Work Permits
- EU citizens: No restrictions
- Non-EU: Need visa permitting work
- Autónomo (self-employed) possible with right visa

### Banking
- Systems old-fashioned
- Physical presence often required
- International transfers can be slow
- Keep UK/EU bank as backup

### Housing
- Competitive in popular areas
- Landlords prefer longer contracts
- Some discrimination against foreigners
- Persistence pays
