# Healthcare System — Tenerife

## System Overview

Spain has universal healthcare. Tenerife's system is good quality, accessible, and affordable.

### Public vs Private

| Aspect | Public (SNS) | Private |
|--------|--------------|---------|
| Cost | Free/low copays | Insurance €40-150/month |
| Access | Based on residency/work | Anyone with insurance |
| Wait times | Variable, can be long | Usually quick |
| Language | Spanish | Often English |
| Quality | Good | Good to excellent |

---

## Public Healthcare (SNS)

### Who's Eligible
- Spanish citizens
- Residents paying social security
- Registered unemployed
- Pensioners
- EU citizens with EHIC/GHIC (temporary)
- Convenio especial (paid scheme)

### Getting Your SIP Card

**SIP = Sistema de Información Poblacional** (Canary Islands health card)

**Process**:
1. Go to your assigned Centro de Salud
2. Bring:
   - NIE
   - Empadronamiento
   - Social security affiliation (if working)
3. Register and receive SIP card
4. Get assigned GP (médico de cabecera)

### Using Public Healthcare

**Routine Care**:
1. Book appointment (cita previa) via:
   - App: "Cita Previa Canarias"
   - Phone: 012 or 922 consultation
   - Online: citasalud.sanidad.gobcan.es
2. Visit Centro de Salud
3. GP refers to specialists if needed

**Urgent (Not Emergency)**:
- Urgencias at Centro de Salud
- PAC (after hours clinics)

**Emergency**:
- Hospital Urgencias
- Call 112 or 061

### Wait Times
| Service | Typical Wait |
|---------|--------------|
| GP appointment | Same day - 1 week |
| Specialist referral | 2 weeks - 3 months |
| Non-urgent surgery | Months |
| Emergency | Triage-based, immediate if serious |

---

## Private Healthcare

### Why Choose Private
- Shorter wait times
- Choose your specialist
- English-speaking options
- Private rooms
- Additional services (dental, optical)

### Insurance Companies

| Provider | Notes | Monthly Cost |
|----------|-------|--------------|
| Asisa | Good value, wide network | €40-80 |
| Sanitas | Largest network | €50-100 |
| Adeslas | Reliable | €50-100 |
| DKV | International focus | €60-120 |
| MAPFRE | Established | €50-90 |

### Without Insurance
Private consultations available pay-per-visit:
| Service | Cost |
|---------|------|
| GP visit | €40-60 |
| Specialist | €60-100 |
| Blood test | €50-100 |
| X-ray | €40-80 |
| MRI | €200-400 |

---

## Hospitals

### Public Hospitals

**Hospital Universitario de Canarias (HUC)**
- Location: La Laguna
- Largest on island
- Trauma center
- Teaching hospital
- All specialties

**Hospital Universitario Nuestra Señora de Candelaria**
- Location: Santa Cruz
- Major hospital
- Full services

**Hospital del Norte**
- Location: Icod
- Serves north region
- Smaller

**Hospital del Sur**
- Location: Arona
- Serves south tourist area
- Modern

### Private Hospitals

**Hospiten Sur**
- Location: Los Cristianos
- Tourist-focused
- English-speaking staff
- Good for visitors

**Hospiten Rambla**
- Location: Santa Cruz
- Central, full services

**Quirónsalud Costa Adeje**
- Location: Costa Adeje
- Premium, modern
- International patients

---

## Pharmacies (Farmacias)

### Finding Pharmacies
- Green cross sign
- Everywhere in towns
- App: Farmacias de guardia

### Hours
- Normal: 9:30-13:30, 17:00-20:30
- Some continuous
- 24h rotation (farmacia de guardia)
- Check door for nearest duty pharmacy

### What's Available
Many medications available without prescription that need Rx elsewhere:
- Pain relief
- Basic antibiotics
- Cold/flu remedies
- Stomach medications
- Contraception

### Tips
- Pharmacists give advice
- Bring existing medication boxes
- Some generics available
- Ask for generic (genérico)

---

## Dental Care

### Public
- Very limited (emergency extractions)
- Children have more coverage
- Adults mostly private

### Private Dental
Affordable compared to UK/Germany:

| Treatment | Price Range |
|-----------|-------------|
| Check-up | €30-50 |
| Cleaning | €40-70 |
| Filling | €50-80 |
| Extraction | €50-100 |
| Root canal | €150-300 |
| Crown | €250-450 |
| Implant | €800-1,500 |

### Finding a Dentist
- Ask for recommendations
- Check Google reviews
- English-speaking available
- Clinics in all towns

---

## Optical Care

### Not Covered Public
- Eye tests
- Glasses
- Contact lenses
- Most eye conditions (unless serious)

### Options
- General Óptica (chain)
- Independent opticians
- Hospital eye departments (serious cases)

### Costs
| Service | Price |
|---------|-------|
| Eye test | €20-40 |
| Basic glasses | €80-150 |
| Progressive lenses | €200-400 |
| Contact lenses (month) | €20-50 |

---

## Mental Health

### Public System
- Available through GP referral
- Psychiatry for serious conditions
- Psychology limited
- Longer waits

### Private Options
- Psychologists: €50-80/session
- Psychiatrists: €80-120/session
- Some English-speaking
- Better availability

### Crisis Resources
- Teléfono de la Esperanza: 717 003 717
- Crisis line: 024
- Emergency: 112

---

## EU Visitors (EHIC/GHIC)

### What It Covers
- Emergency treatment
- Necessary medical care
- Same basis as locals
- Not repatriation

### How to Use
- Present card at public hospital
- May need to pay upfront, reclaim later
- Carry it always
- Not for private healthcare

### Limitations
- Not a substitute for travel insurance
- Pre-existing conditions tricky
- Repatriation not covered
- Non-urgent treatment limited

---

## Specific Conditions

### Chronic Conditions
- Can transfer prescriptions
- Public system manages
- Bring medical summary
- Regular appointments bookable

### Pregnancy
- Full public coverage
- Regular check-ups
- Hospital birth
- Midwife (matrona) led
- Private options available

### Pediatrics
- Children well covered
- Vaccines included
- Centro de Salud + hospital
- Emergency pediatric units

---

## Medical Tourism

### Why Tenerife
- Lower costs than UK/Germany
- Good quality
- Recovery climate
- Dental tourism popular
- Cosmetic surgery available

### Considerations
- Research providers
- Check credentials
- Plan recovery time
- Travel insurance important
