# Food Practicalities — Tenerife

## Markets

### Major Markets

**Mercado de Nuestra Señora de África (Santa Cruz)**
- Main city market
- Two floors: produce + tapas bars
- Monday-Saturday 6:00-14:00
- Sunday reduced hours
- Best for: Fresh produce, fish, cheese, atmosphere

**Mercado La Laguna**
- Historic market
- Fresh produce, butchers
- Monday-Saturday mornings
- Smaller, more local

**Mercado de Puerto de la Cruz**
- Tourist-friendly
- Good produce section
- Prepared foods
- Daily except Sunday

### Farmers Markets (Mercadillos)

| Day | Market | Location | Notes |
|-----|--------|----------|-------|
| Saturday | Tegueste | Tegueste | Largest, most authentic |
| Sunday | La Laguna | Parque La Vega | Organic focus, crafts |
| Sunday | Santa Cruz | Various | Check location |
| Wednesday | Los Cristianos | Town center | Tourist-oriented |
| Thursday | La Laguna | Calle Herradores | Smaller |
| Saturday | Puerto Cruz | Centro | Good produce |

### What to Buy

**Fresh Produce**
- Plátanos de Canarias (local bananas)
- Papas (various potato varieties)
- Tropical fruits (papaya, mango, chirimoya)
- Tomatoes (excellent local)
- Avocados (local grown)

**Specialty Items**
- Mojo (fresh, refrigerate)
- Gofio (various mills)
- Queso (local goat cheese)
- Miel de palma (palm honey from La Gomera)
- Ron miel (honey rum)
- Local wines

---

## Supermarkets

### Chains Ranked

**Mercadona** ⭐⭐⭐⭐⭐
- Best overall value
- Good prepared foods
- Reliable quality
- Everywhere

**HiperDino** ⭐⭐⭐⭐
- Local Canarian chain
- Good local products
- Reasonable prices
- Good coverage

**Lidl** ⭐⭐⭐
- German discount
- Limited selection
- Good bakery
- Lowest prices on basics

**Alcampo** ⭐⭐⭐⭐
- Hypermarket (large)
- Everything under one roof
- La Laguna, Santa Cruz

**SuperDino / HiperDino Express** ⭐⭐⭐
- Convenience versions
- Higher prices
- Quick stops

### Opening Hours
- Typical: 9:00-21:00 (some 22:00)
- Sunday: Many open (9:00-14:00 or longer)
- Holidays: Check individual stores

### Pricing Reality
Groceries are affordable:
| Item | Typical Price |
|------|---------------|
| Bread | €0.60-1.50 |
| Milk (1L) | €0.80-1.20 |
| Eggs (12) | €2.00-3.00 |
| Chicken breast (kg) | €6-8 |
| Local cheese | €8-15/kg |
| Wine (decent bottle) | €3-8 |
| Beer (6-pack) | €3-5 |

---

## Wine Buying

### Where to Buy

**Supermarkets**
- Decent selection of local wines
- €3-8 for good quality
- Limited top-end

**Bodegas Direct**
- Better selection
- Can taste first
- Similar or better prices
- Bodegas Monje, Casa del Vino

**Wine Shops**
- El Gusto por el Vino (La Laguna)
- Various in Santa Cruz
- Better guidance

### What to Look For
- **DO labels**: Denomination of Origin ensures quality
- **Tacoronte-Acentejo**: Most accessible reds
- **Valle de la Orotava**: Elegant options
- **Malvasía**: Traditional sweet/dry whites

### Price Guidance
| Level | Price | Expectation |
|-------|-------|-------------|
| Table wine | €2-4 | Basic, fine for cooking |
| Good daily | €4-8 | Quality local wines |
| Special occasion | €10-20 | Top producers |
| Premium | €20+ | Best of Canarias |

---

## Alcohol Rules

### Basics
- Legal drinking age: 18
- Available everywhere (supermarkets, shops)
- No public drinking restrictions (unlike some regions)
- Drunk driving: Strict laws, 0.25mg/L breath limit

### Where to Buy
- Supermarkets: Wine, beer, spirits
- Estancos (tobacconists): Some alcohol
- 24h shops: Tourist areas, limited and expensive

---

## Dietary Requirements

### Vegetarian
- Increasingly common
- Canarian cuisine naturally has options:
  - Papas arrugadas (vegan if no butter)
  - Pimientos
  - Salads
  - Gofio dishes
- Say: "Soy vegetariano/a"

### Vegan
- Growing awareness
- Still challenging in traditional restaurants
- La Laguna best options
- Check mojo ingredients (usually vegan)
- Say: "Soy vegano/a, no como nada de animal"

### Gluten-Free
- Awareness moderate
- Gofio can be wheat or corn (ask)
- Papas arrugadas safe
- Supermarkets have "sin gluten" sections
- Say: "Soy celíaco/a" or "Sin gluten, por favor"

### Allergies
- Shellfish: Common in Canarian cuisine
- Nuts: Almonds in many desserts
- Always ask about ingredients
- Say: "Tengo alergia a [X]"

---

## Restaurant Practicalities

### Reservations
- **Fine dining**: Essential, 1-2 weeks ahead
- **Popular restaurants**: Recommended, especially weekends
- **Casual**: Usually not needed
- **How**: Phone, TheFork app, WhatsApp increasingly

### Tipping
- Not obligatory or expected
- Locals might round up
- For excellent service: 5-10%
- Already included in price (no American-style obligation)

### Paying
- Cash still preferred many places
- Cards widely accepted
- Minimum amounts common (€5-10)
- Splitting bills: Ask for "cuentas separadas"

### Menú del Día
- Lunch deal, typically:
  - First course (starter)
  - Second course (main)
  - Dessert or coffee
  - Bread and drink included
- Price: €8-15
- Available Monday-Friday lunch
- Best value eating

### Service Charge
- "Servicio" sometimes added for groups
- Check bill before tipping
- IVA (VAT at 7%) always included

---

## Meal Timing

### Spanish Schedule
| Meal | Time | Notes |
|------|------|-------|
| Desayuno | 7:00-10:00 | Light (coffee, toast) |
| Almuerzo | 14:00-16:00 | Main meal |
| Merienda | 17:00-19:00 | Light snack |
| Cena | 21:00-23:00 | Dinner, can be lighter |

### Reality for Visitors
- Tourist areas serve earlier
- You can find food most hours in south
- North more traditional timing
- Restaurants often close 16:00-20:00

### Kitchen Hours
- Lunch service: 13:00-15:30 (last orders)
- Dinner service: 20:00-22:30 (last orders)
- Bars with food: More flexible
- Fast food: Standard hours

---

## Delivery & Takeaway

### Apps
- **Glovo**: Most common, good coverage
- **Just Eat**: Available
- **Uber Eats**: Limited coverage
- **WhatsApp**: Many restaurants do direct delivery

### Coverage
- South: Good coverage
- Santa Cruz/La Laguna: Good
- Puerto de la Cruz: Moderate
- Rural: Limited to none

### Typical Delivery Fee
€1-3 depending on distance

---

## Coffee Culture

### Ordering Coffee

| Order | What You Get |
|-------|-------------|
| Café solo | Espresso |
| Cortado | Espresso + small milk |
| Café con leche | Latte-style |
| Americano | Long black |
| Barraquito | Tenerife special (layered with condensed milk, liqueur) |

### Coffee Prices
- Café solo: €1.00-1.50
- Cortado: €1.20-1.80
- Café con leche: €1.50-2.50
- Specialty coffee shops: €2.50-4.00

### Specialty Coffee
Growing scene:
- La Máquina (La Laguna)
- Various in Santa Cruz
- Some in El Médano
- Less common than mainland cities

---

## Water

### Tap Water
- Safe to drink
- Volcanic minerals affect taste
- Many locals buy bottled
- Restaurants charge for water (€1-3)

### Bottled Water
- Supermarket: €0.30-0.80
- Restaurant: €1.50-3.00
- Sparkling (con gas) available
