# Tenerife Food Overview

## Canarian Cuisine

Tenerife's food reflects its unique position: Spanish base, African influence, Atlantic seafood, and volcanic terroir.

### Core Elements
- **Papas arrugadas**: Wrinkly potatoes boiled in very salty water
- **Mojos**: Red (spicy) and green (cilantro/parsley) sauces
- **Gofio**: Toasted grain flour (pre-Hispanic staple)
- **Fresh fish**: Vieja, cherne, sama, bocinegro
- **Goat cheese**: Aged and fresh varieties
- **Canarian wines**: Unique volcanic terroir

### Meal Culture
- **Desayuno** (breakfast): Light — coffee, toast with tomato or butter
- **Almuerzo** (lunch): Main meal, 14:00-16:00
- **Cena** (dinner): Lighter, 21:00-23:00
- **Menú del día**: Set lunch menu €8-15, excellent value

---

## Dining Landscape

### Restaurant Tiers

| Type | Description | Price Range |
|------|-------------|-------------|
| Guachinche | Home winemakers serving simple food | €5-12 |
| Tasca / Bar | Traditional tapas bars | €8-18 |
| Restaurante típico | Traditional Canarian restaurant | €15-30 |
| Marisquería | Seafood specialist | €20-45 |
| Contemporary Canarian | Modern takes on local cuisine | €25-50 |
| Fine dining | Michelin and aspirational | €60-150+ |

### Where to Find What

| Food Style | Best Areas |
|------------|------------|
| Traditional Canarian | La Laguna, La Orotava, Puerto de la Cruz |
| Seafood | La Caleta, Puerto de la Cruz, Taganana |
| Fine dining | Costa Adeje, Abama, La Caleta |
| International variety | Costa Adeje, Las Américas |
| Guachinches | Tacoronte, La Orotava, Tegueste |
| Vegetarian/vegan | La Laguna, El Médano |

---

## Guachinches — Don't Miss

Traditional home restaurants in wine country:
- Family runs bodega (winery)
- Serve own wine + simple home cooking
- Very limited menu (what's available)
- Often seasonal (harvest time best)
- No signs usually — ask locals
- Cash only typically
- Best experience on island

**Finding them**:
- Ask at local bars
- Facebook groups ("Guachinches de Tenerife")
- Drive around Tacoronte/La Matanza area
- Look for cars parked outside unmarked houses

**Expect**:
- House wine by the bottle (€3-6)
- Simple food: carne fiesta, costillas, potatoes
- Paper tablecloths
- No menu, no frills
- Cash

---

## Must-Try Dishes

### Appetizers (Entrantes)
| Dish | Description |
|------|-------------|
| Papas arrugadas con mojo | The essential Canarian dish |
| Gofio escaldado | Gofio mixed with fish broth |
| Queso asado con mojo | Grilled goat cheese with sauce |
| Jamón serrano | Spanish cured ham |
| Pimientos de padrón | Small peppers, some spicy |

### Mains (Platos principales)
| Dish | Description |
|------|-------------|
| Ropa vieja | Shredded beef with chickpeas |
| Puchero canario | Canarian stew (meat, vegetables, chickpeas) |
| Carne fiesta | Marinated pork chunks |
| Conejo en salmorejo | Rabbit in garlic-paprika marinade |
| Pescado a la espalda | Fish split and grilled |
| Sancocho | Salted fish with sweet potato, gofio |

### Desserts (Postres)
| Dish | Description |
|------|-------------|
| Bienmesabe | Almond cream dessert |
| Frangollo | Corn flour pudding with almonds |
| Quesillo | Canarian flan |
| Truchas | Sweet potato filled pastries |
| Plátano frito | Fried banana with honey |

---

## Wine Culture

### Denominations of Origin

| DO | Character | Best For |
|----|-----------|----------|
| Tacoronte-Acentejo | Reds from listán negro | Everyday drinking |
| Valle de la Orotava | Elegant whites and reds | Wine enthusiasts |
| Ycoden-Daute-Isora | Whites, coastal influence | Light meals |
| Abona | High altitude wines | Distinctive character |
| Valle de Güímar | Small production, unique | Collectors |

### What to Try
- **Listán Negro**: Indigenous red grape, light-medium bodied
- **Listán Blanco**: Fresh white, Canarian classic
- **Malvasía**: Sweet/dry whites, historic variety
- **Baboso Negro**: Deep red, limited production
- **Vijariego**: Crisp white, gaining popularity

### Wine Experiences
- **Bodegas Monje**: Tours, tastings, restaurant
- **Casa del Vino**: Museum and tastings (El Sauzal)
- **Guachinche route**: Drink at source
- **Tacoronte-Acentejo route**: Multiple bodegas

---

## Budget Eating

### Best Value
- **Menú del día**: Lunch special €8-14 (3 courses + drink)
- **Guachinches**: €10-15 for wine + food
- **Bocadillos**: Sandwiches €3-5
- **Supermarket prepared**: Mercadona hot food €3-6
- **Canarian breakfast**: Coffee + toast €2-3

### Supermarkets
- **Mercadona**: Best overall, prepared foods
- **Lidl**: Good prices, limited selection
- **HiperDino**: Local chain, good quality
- **Alcampo**: Hypermarket, largest selection

---

## Splurge Dining

### Michelin-Starred
- **M.B** (Abama): Martín Berasategui, 2 stars
- **Kabuki** (Abama): Japanese, 1 star
- **NUB** (La Caleta): Creative, 1 star
- **El Rincón de Juan Carlos** (Los Gigantes): Canarian, 1 star

### Destination Restaurants
- **La Vieja** (La Caleta): Modern Canarian
- **Régulo** (Puerto de la Cruz): Historic house setting
- **El Molino Blanco** (La Caleta): Classic fine dining
- **Haydée** (La Orotava): Contemporary Canarian

---

## Food Calendar

### Seasonal Highlights
| Month | What's Special |
|-------|----------------|
| Jan-Feb | Carnival food, chicharros |
| Mar-Apr | Semana Santa sweets |
| May-Jun | Fresh tuna, first harvests |
| Jul-Aug | Tropical fruits peak |
| Sep-Oct | Wine harvest, guachinche season |
| Nov-Dec | Christmas sweets, chestnuts |

### Food Festivals
- **Tapas routes**: Various towns, check locally
- **Wine festivals**: Harvest time (September)
- **Fish festivals**: Coastal towns throughout year
- **Sancocho**: May (fishing tradition)
