# Schools & Education — Tenerife

## System Overview

Spanish education is compulsory ages 6-16. Options include public, concertado (semi-private), and fully private schools.

### Education Stages

| Stage | Ages | Years |
|-------|------|-------|
| Educación Infantil | 0-6 | Optional pre-school |
| Educación Primaria | 6-12 | Compulsory |
| ESO (Secondary) | 12-16 | Compulsory |
| Bachillerato | 16-18 | Pre-university |
| FP (Vocational) | 16+ | Technical training |
| Universidad | 18+ | Higher education |

---

## Public Schools

### Pros
- Free (including books often)
- Good quality generally
- Integration with local community
- Spanish language immersion
- All areas covered

### Cons
- Spanish language instruction
- Larger class sizes
- Less flexibility
- Variable quality by area

### How to Enroll
1. Find schools in your area (consult ayuntamiento)
2. Apply during enrollment period (March-April usually)
3. Provide:
   - NIE for parents
   - NIE for child (or passport)
   - Empadronamiento
   - Vaccination record
   - Previous school records (translated)
4. Assignment based on criteria (proximity, siblings, etc.)

### Language Adaptation
- Many schools have "aulas de acogida" (welcome classrooms)
- Extra Spanish support for non-Spanish speakers
- Children adapt faster than expected
- Generally recommended for long-term stays

---

## Private Schools

### Types

**British Curriculum**
- Follow UK system
- English instruction
- GCSE, A-Levels
- Good for short-term stays or return to UK

**American Curriculum**
- US-style education
- English instruction
- High school diploma
- SAT preparation

**German Curriculum**
- German system
- German/Spanish instruction
- Abitur qualification

**French Curriculum**
- French system
- French instruction
- Baccalauréat

**International (IB)**
- International Baccalaureate
- Globally recognized
- English instruction usually

### Main International Schools

**British School of Tenerife**
- Location: Puerto de la Cruz / La Orotava
- Curriculum: British (EYFS to A-Level)
- Language: English
- Fees: €5,000-10,000/year
- Good reputation

**Wingate School**
- Location: Arona (south)
- Curriculum: British
- Language: English
- Fees: €5,000-9,000/year
- Convenient for south residents

**Colegio Alemán / Deutsche Schule**
- Location: Santa Cruz / Tabaiba
- Curriculum: German
- Language: German/Spanish
- Fees: €5,000-8,000/year

**Lycée Français**
- Location: Santa Cruz
- Curriculum: French
- Language: French
- Fees: €4,000-7,000/year

**Colegio Europeo**
- Location: Various
- Multiple curricula options

### Choosing a School

**Consider**:
- How long you're staying
- Language goals for children
- Return plans (curriculum matters)
- Location (commute)
- Budget
- School community/culture

---

## Concertado (Semi-Private)

### What They Are
- Government-subsidized private schools
- Lower fees than fully private
- Often religious affiliation
- Spanish curriculum mostly
- Some bilingual programs

### Fees
- €50-300/month (much less than private)
- Covers extras (activities, materials)
- Main education subsidized

### Application
- Similar to public
- Application periods
- Some selection criteria
- Popular ones competitive

---

## Pre-School (0-6 years)

### Options

**Guarderías (Nurseries)** — 0-3 years
- Public: Limited, very cheap
- Private: €200-500/month
- Company-sponsored sometimes

**Educación Infantil** — 3-6 years
- Free in public schools
- Not compulsory but common
- Good for language acquisition

---

## University

### Universidad de La Laguna (ULL)
- Main university on island
- Public
- Wide range of programs
- Spanish instruction mostly
- Affordable fees

### Programs
- Medicine, Law, Engineering, Sciences
- Some programs in English
- Erasmus exchanges
- Good for EU students

### Fees
- Spanish/EU residents: €700-1,500/year
- Non-EU: Higher (varies)
- Still much less than UK/US

---

## Homeschooling

### Legal Status
- **Legally gray area in Spain**
- Not explicitly legal or illegal
- No official framework
- Some families do it
- Risk of truancy accusations

### Practical Reality
- Some international families homeschool
- Correspondence courses from home country
- Online academies
- Low enforcement but technically required to enroll

---

## Language Considerations

### For Young Children (under 8)
- Usually adapt quickly
- Total immersion works
- Few months to fluency
- Recommend public/local schools

### Older Children
- More challenging transition
- May need language support
- International school easier short-term
- Consider timing of move

### Summer Language Programs
- Options for Spanish immersion
- University programs
- Private academies
- Good preparation

---

## Practical Tips

### Before Moving
- Request school records
- Get translations (official)
- Research schools in target area
- Contact schools directly
- Visit if possible

### Enrollment Period
- Main period: March-April
- Some flexibility for foreign arrivals
- Start process early
- Contact Consejería de Educación if issues

### Documentation Needed
- NIE (parents and child)
- Empadronamiento
- Passport/birth certificate
- Previous school records (translated, apostilled for private)
- Vaccination record
- Photos

### School Year
- September to June
- Summer: Late June to early September
- Christmas: ~2 weeks
- Easter: ~2 weeks
- Various bank holidays

---

## Costs Summary

| Type | Monthly/Annual Cost |
|------|---------------------|
| Public | Free (minimal extras) |
| Concertado | €50-300/month |
| Private Spanish | €300-600/month |
| International | €400-1,000/month |
| University (EU) | €700-1,500/year |

---

## Resources

- **Consejería de Educación**: www.gobiernodecanarias.org/educacion
- **School finder**: Various online directories
- **British schools**: NABSS (association)
- **Expat groups**: Facebook has parent groups
