# Driving & Car Ownership — Tenerife

## Driving Overview

Car gives freedom on Tenerife. Public transport exists but car transforms the experience.

### Do You Need a Car?

**Yes if**:
- Living outside Santa Cruz/La Laguna
- Want to explore regularly
- Have family/children
- Rural areas
- Work in multiple locations

**Maybe not if**:
- Central La Laguna/Santa Cruz
- El Médano (walkable + nomad lifestyle)
- Short-term tourist (taxis + tours)
- Committed to one beach area

---

## Driving License

### EU Licenses
- Valid indefinitely in Spain
- No exchange needed
- Carry when driving

### UK License (Post-Brexit)
- Valid for 6 months as resident
- Then must exchange
- Tourists: Valid during visit

### Non-EU Licenses
- International permit recommended
- With original license
- Valid 6-12 months depending on nationality
- Exchange if staying long-term

### License Exchange Process

**Requirements**:
1. Appointment at DGT (Traffic Dept)
2. Medical exam (€25-40)
3. Application form
4. Original license
5. Photos
6. Fee (~€30)

**Countries with agreement**: Exchange without test
**Others**: May require test

---

## Renting a Car

### Companies

**Recommended (Local)**
- **Cicar**: Best reputation, good service
- **TopCar**: Reliable, competitive
- **AutoReisen**: Good value
- **Plus Car**: Budget friendly

**International**
- Hertz, Europcar, Avis (usually pricier)

### Prices
| Season | Daily | Weekly |
|--------|-------|--------|
| Low | €15-25 | €90-140 |
| Mid | €25-35 | €140-200 |
| High | €35-50 | €200-300 |

### Tips
- Book online in advance (much cheaper)
- Full insurance worth it (mountain roads)
- Check fuel policy (full-full best)
- Inspect car thoroughly at pickup
- Photograph existing damage
- Diesel most common

---

## Buying a Car

### New Cars
- Dealerships in all main towns
- Spanish spec same as EU
- Financing available
- Full warranty

### Used Cars
- **Coches.net**: Main used car site
- **Milanuncios**: Classifieds
- **Facebook Marketplace**: Check local groups
- **Dealers**: Some certified pre-owned

### What to Check
- ITV history (inspection)
- Outstanding fines (ask for proof of none)
- Accident history
- Rust (coastal salt air)
- Kilometers
- Service history

### Prices (Used)
| Type | Age | Price Range |
|------|-----|-------------|
| Small (Polo, Ibiza) | 5-8 years | €5,000-10,000 |
| Compact (Golf, Leon) | 5-8 years | €8,000-15,000 |
| SUV | 5-8 years | €12,000-25,000 |

---

## Registration & Paperwork

### Transferring Ownership

**Process**:
1. Sign sales contract (compraventa)
2. Pay transfer tax (ITP) ~4% of value
3. Transfer at Tráfico office
4. Update insurance

**Documents needed**:
- Both parties' ID/NIE
- Ficha técnica (vehicle registration)
- ITV in date
- Insurance proof
- Proof of no outstanding fines

### Matriculación (New Import)
Complex process if bringing car from outside:
- Homologation sometimes needed
- Import taxes
- Re-registration
- Consider buying locally instead

---

## ITV (Vehicle Inspection)

### What It Is
Annual technical inspection (like UK MOT, German TÜV).

### Schedule
- New cars: First after 4 years
- 4-10 years: Every 2 years
- 10+ years: Annually

### Process
1. Book appointment at ITV station
2. Bring:
   - Ficha técnica
   - ID
   - Insurance proof
3. Inspection takes ~30 min
4. Pass: Get sticker
5. Fail: Fix issues, retest

### Cost
- €35-50 depending on vehicle type

### Stations
- Granadilla (south)
- La Laguna
- Puerto de la Cruz
- Santa Cruz

---

## Insurance

### Required
Third party (responsabilidad civil) minimum.

### Recommended
Comprehensive (todo riesgo) for:
- Mountain road risks
- Tourist driving
- New/valuable cars

### Costs
| Coverage | Annual |
|----------|--------|
| Third party | €200-350 |
| Third party + theft/fire | €300-450 |
| Comprehensive | €400-700 |

### Companies
- Línea Directa (online, competitive)
- Mutua Madrileña (good service)
- MAPFRE (large network)
- AXA, Allianz (international)

---

## Driving Conditions

### Mountain Roads

**What to Expect**:
- Hairpin bends (many)
- Steep gradients
- Single lane sections (some)
- Stunning views (don't get distracted)
- Well maintained generally

**Tips**:
- Use low gears downhill
- Honk on blind curves
- Let faster traffic pass
- Don't rush
- Pull over for views safely

### Specific Roads

| Road | Character | Notes |
|------|-----------|-------|
| TF-1 (South highway) | Easy motorway | Main artery |
| TF-5 (North highway) | Easy motorway | To Puerto/La Orotava |
| TF-21 (Teide) | Mountain, good condition | Popular, watch weather |
| TF-82 (Masca) | Narrow, winding | Challenging, scenic |
| TF-12 (Anaga) | Winding, forest | Atmospheric |

### Weather Impacts
- Fog (north coast, mountains)
- Rain makes roads slippery
- Wind (east coast, bridges)
- Snow (Teide in winter, rare closure)

---

## Parking

### Types

**White lines**: Free parking
**Blue lines (ORA)**: Paid, time-limited
**Yellow lines**: No parking
**Green**: Residents only (some areas)

### Costs
- Street parking (blue): €0.50-1.50/hour
- Car parks: €1-2/hour
- Airport: €8-12/day

### Tips
- Finding parking challenging in:
  - Santa Cruz center
  - La Laguna old town
  - Costa Adeje beaches
- Underground car parks available
- Double parking tolerated briefly (hazards on)

---

## Fuel

### Prices
- Cheaper than mainland Spain
- Currently ~€1.40-1.60/L diesel
- Petrol slightly more

### Stations
- Widespread
- Most accept cards
- Some 24h automated
- Full service rare

### Electric Vehicles
- Growing charging network
- Mostly in towns
- Tesla superchargers limited
- Rental EVs available

---

## Traffic & Rules

### Speed Limits
| Road | Limit |
|------|-------|
| Urban | 30-50 km/h |
| Secondary | 90 km/h |
| Highway | 120 km/h |

### Enforcement
- Speed cameras common
- Fines arrive by post (even months later)
- Points system (lose license at 12 points lost)
- Drunk driving strict (0.25mg/L breath)

### Rules to Know
- Right-hand traffic
- Seat belts mandatory all
- Phone: Hands-free only
- Roundabouts: Give way to traffic in circle
- Children: Appropriate seats required

---

## Common Issues

### Accidents
1. Move to safety if possible
2. Call 112 if injuries
3. Exchange details
4. Take photos
5. Call insurance
6. European Accident Statement (recommended to carry)

### Breakdown
- Call insurance breakdown service
- RACE (automobile club): 900 100 992
- Pull safely off road
- Reflective vest and triangles required

### Parking Fines
- Pay promptly (50% discount usually)
- Can dispute but difficult
- Check car regularly for tickets
