# Culture & Customs — Tenerife

## Canarian Identity

Tenerife is Spanish, but distinctly Canarian — a blend of Spanish, indigenous Guanche, African, and Latin American influences.

### Key Cultural Points
- **Guanche heritage**: Indigenous people, pre-Spanish conquest
- **Spanish base**: Language, religion, legal system
- **Island mentality**: Relaxed pace, community-focused
- **Mix of influences**: Africa nearby, Latin America connected
- **Tourism coexistence**: Locals live alongside visitor economy

---

## Daily Life Rhythms

### Schedule
| Activity | Typical Time |
|----------|-------------|
| Breakfast | 7:00-10:00 |
| Work | 8:00-14:00, 17:00-20:00 (traditional) |
| Lunch | 14:00-16:00 |
| Siesta | 14:00-17:00 (shops may close) |
| Evening paseo | 18:00-21:00 |
| Dinner | 21:00-23:00 |
| Nightlife | 23:00+ |

### "Island Time"
- Things happen when they happen
- Punctuality flexible
- Rushing is uncommon
- Patience appreciated
- Don't stress about delays

---

## Social Customs

### Greetings
- **Two kisses** (cheek): Friends, acquaintances, introductions
- **Handshake**: Formal/business first meetings
- **Abrazo** (hug): Close friends, family
- **Men**: Usually handshake, close friends may kiss

### Forms of Address
- **Tú**: Informal "you" — most situations
- **Usted**: Formal "you" — elderly, officials, formal
- **Canarians lean informal** compared to mainland

### Social Norms
- Eye contact important
- Personal space closer than Northern Europe
- Touching while talking normal
- Speaking loudly isn't rude
- Interrupting part of animated conversation

---

## Language

### Spanish (Castilian)
- Official language
- Everyone speaks it
- Learn basics at minimum

### Canarian Accent
- Distinctive from mainland
- Similar to Caribbean Spanish (historical connection)
- Some unique vocabulary
- Softer consonants
- Faster pace

### Canarian Words
| Word | Meaning | Mainland Equivalent |
|------|---------|---------------------|
| Guagua | Bus | Autobús |
| Papa | Potato | Patata |
| Millo | Corn | Maíz |
| Chacho | Dude/mate | Tío |
| Guiri | Foreign tourist | — |
| Chinijo | Small child | Niño pequeño |

### English
- Widely spoken in tourist areas
- Less common in north and local areas
- Older generation less likely to speak
- Spanish opens doors

---

## Religion

### Catholic Heritage
- Most are nominal Catholics
- Churches important architecturally
- Religious festivals big events
- Less practicing than past

### Key Religious Events
- **Semana Santa** (Easter week): Processions
- **Corpus Christi**: Flower carpets (La Orotava famous)
- **Patron saint days**: Every town has one
- **Christmas**: Family-focused

---

## Festivals & Celebrations

### Carnival (February/March)
- **Santa Cruz Carnival**: Second biggest after Rio
- Weeks of events
- Elaborate costumes
- Drag queen gala (famous)
- Parade (Coso)
- Book accommodation months ahead

### Major Fiestas

| Festival | When | Where | What |
|----------|------|-------|------|
| Carnival | Feb/Mar | Santa Cruz, everywhere | Costumes, parades, parties |
| Corpus Christi | May/Jun | La Orotava | Flower carpet art |
| San Juan | June 23 | Beaches | Bonfires, swimming |
| Virgen de Candelaria | August 15 | Candelaria | Pilgrimage |
| Romerías | Various | Various | Traditional pilgrimages |

### Local Fiestas
- Every town has patron saint festival
- Check local ayuntamiento for dates
- Traditional dress, music, food
- Authentic experiences

---

## Food Culture

### Meal Traditions
- Lunch is main meal
- Family meals important
- Sunday lunch sacred
- Eating is social, not rushed
- Share dishes common

### Dining Etiquette
- Wait to be seated (sometimes)
- Bread automatically arrives
- Water usually charged
- Coffee after dessert
- Long meals are normal
- Bill won't come until you ask

### Tipping
- Not obligatory
- Round up or 5-10% appreciated
- Already included in price

---

## Work Culture

### Business Hours
- Traditional: 9-14:00, 17-20:00
- Modern: 9-18:00 (continuous)
- Friday afternoons: Often short
- August: Many close for holidays

### Business Style
- Relationships first
- Decisions take time
- Formality initial, then relaxes
- Lunch meetings common
- Evening networking happens

---

## Dress Code

### Casual Island Style
- Relaxed generally
- Beach wear: Only at beach
- Cover up for town
- Smart casual for dinner
- No strict rules

### What to Avoid
- Swimwear in shops/restaurants
- Very skimpy clothing in towns
- Bare feet off beach
- Nothing offensive

---

## Housing & Neighbors

### Community Living
- Neighbors matter
- Greet people in building
- Noise awareness expected
- Share spaces respectfully
- Community president in buildings

### Noise
- Spain is noisy
- Conversations are loud
- Late nights normal
- But respect quiet hours
- Complaints go to police if serious

---

## Driving Culture

### On the Road
- Horn use communicative
- Double parking accepted briefly
- Flexible interpretation of rules
- But speed cameras strict

### Parking Reality
- Creative parking happens
- Blue zones paid
- White zones free
- Yellow = no parking

---

## Expat Integration

### Tips for Fitting In
- Learn Spanish (seriously)
- Shop at local markets
- Eat at local times
- Join local activities
- Be patient with pace
- Show interest in culture
- Don't complain about Spain

### Common Mistakes
- Staying in expat bubble
- Expecting British/German efficiency
- Eating at tourist restaurants only
- Not learning language
- Complaining about siesta

---

## LGBTQ+

### Generally Accepting
- Spain legalized same-sex marriage 2005
- Tenerife welcoming
- Pride events (Santa Cruz)
- Gay-friendly venues in south

### Reality
- Smaller islands more conservative
- Public affection fine in most areas
- Some rural areas more traditional
- Overall very safe

---

## Useful Cultural Knowledge

### Gestures
- Thumb and finger rub: Money
- Hand under chin flick: Don't care
- Finger wagging: No
- Eye point: Watch out

### Topics to Avoid (Initially)
- Politics (left/right divide)
- Catalan independence (contentious)
- Franco era
- Criticism of Spain

### Safe Topics
- Food and wine
- Football (Tenerife: CD Tenerife)
- Travel
- Family
- Weather (always good topic)
