# Coworking & Tech Scene — Tenerife

## Coworking Landscape

Tenerife's coworking scene is smaller than mainland cities but growing with the nomad influx.

### Overview by Area

| Area | Options | Quality | Community |
|------|---------|---------|-----------|
| El Médano | Coliving-based | Good | Strong |
| Costa Adeje | Few dedicated | Variable | Sparse |
| Santa Cruz | Limited | Basic | Local |
| La Laguna | Cafes mainly | Variable | Student mix |
| Puerto de la Cruz | Very limited | Basic | Small |

---

## Dedicated Coworking Spaces

### El Médano

**Restation Coworking**
- Part of coliving but open to non-residents
- Day pass: ~€20
- Monthly: Part of coliving package
- Good WiFi, community events
- Social atmosphere

**Nine Coliving Workspace**
- Premium setup
- Day pass available
- Modern facilities
- Quieter, more focused

### Costa Adeje

**Limited dedicated options**
- Some shared office spaces
- Hotel business centers
- Check Google Maps for current

### Santa Cruz

**Various shared offices**
- More traditional coworking
- Less nomad-focused
- Spanish-speaking environments

### La Laguna

**No major coworking**
- University library (if enrolled)
- Cafe culture dominant
- Some shared offices

---

## Cafe Working

### Best Cafes by Area

**La Laguna** (Best cafe working)
- La Máquina: Specialty coffee, good WiFi
- Café Teatro: Classic, plaza views
- Various along Calle Herradores
- University area options

**El Médano**
- Several beachfront options
- Variable WiFi quality
- Better in off-peak hours

**Santa Cruz**
- Various in centro
- García Sanabria park area
- Less tourist, more local

**Puerto de la Cruz**
- Centro options
- Some hotel cafes
- Less common working culture

### Cafe Etiquette
- Buy something every 1-2 hours
- Don't take tables during rush
- Ask about WiFi before settling
- Be mindful of calls
- Tip if staying long

---

## Alternative Work Spots

### Libraries
- Limited laptop-friendly
- University library (La Laguna) best
- Municipal libraries exist
- Variable WiFi

### Hotel Lobbies
- Some welcoming to non-guests
- Often excellent WiFi
- May need to buy coffee
- Check policy first

### Coworking at Accommodation
- Many Airbnbs have good setups
- Coliving includes workspace
- Ask specifically about desk/chair
- Verify internet speed

---

## Tech Scene

### Local Tech Industry

**Reality Check**
- Small local tech sector
- Most tech workers are remote
- Limited startups on island
- More lifestyle entrepreneurs

**What Exists**
- Some software companies
- Tourism tech
- Digital agencies
- Freelancers

### Meetups & Events

**Tech Events**
- Occasional tech meetups
- Check meetup.com
- Facebook groups
- Sporadic rather than regular

**Startup Events**
- Less common than mainland
- CIDE (business incubator) events
- Occasionally visiting events

### Networking
- Digital nomad events more active than tech events
- LinkedIn for professional connections
- Join remote work communities
- Consider mainland trips for serious networking

---

## Remote-Friendly Companies

### Companies with Canary Islands Employees

**Direct Presence**
- Few major tech companies have offices
- Some have remote employees

**Remote-First Hiring**
- Spanish companies hiring remote
- International remote-first companies
- Freelance/contract work common

### Finding Remote Work

**Platforms**
- LinkedIn (set location to Spain)
- We Work Remotely
- Remote OK
- AngelList
- TopTal, Upwork (freelance)

**Spanish Opportunities**
- InfoJobs (Spanish)
- Domestika (creative)
- Spanish startups going remote

---

## Internet Infrastructure

### Fiber Coverage

| Area | Coverage | Typical Speed |
|------|----------|---------------|
| Santa Cruz | Excellent | 600 Mbps |
| La Laguna | Excellent | 600 Mbps |
| Costa Adeje | Good | 300-600 Mbps |
| El Médano | Good | 300-600 Mbps |
| Puerto de la Cruz | Good | 300 Mbps |
| Rural | Variable | DSL-300 Mbps |

### Providers
- Movistar: Best coverage
- Vodafone: Good speeds
- Orange: Competitive
- Digi: Cheapest

### Mobile Backup
- 4G everywhere (towns)
- 5G limited rollout
- Useful redundancy
- Unlimited data plans affordable

---

## Working Hours & Lifestyle

### Time Zone Considerations

**GMT/GMT+1 (Canary Time)**
- Same as UK
- 1 hour behind mainland Spain
- Workable for EU clients
- Morning overlap with US East Coast

### Typical Nomad Schedules

**EU-Focused**
- Normal 9-5 works perfectly
- Evening calls rare
- Full work-life balance

**US-Focused**
- Morning free (beach, hike)
- Work afternoon/evening
- Calls 14:00-22:00 Canary time

**Mixed Global**
- Some early, some late
- Async communication important
- Flexible schedule essential

### Work-Life Balance
- Morning surf/swim possible
- Long lunch breaks cultural
- Evening social activities
- Weekend exploration
- Best part of island life

---

## Practical Setup

### Essential Gear
- Laptop with good battery
- Noise-canceling headphones
- Backup charger
- Phone hotspot capability
- Travel adapter (EU)

### Software
- VPN for geo-restricted content
- Video conferencing (Zoom, Meet)
- Async tools (Slack, Notion)
- Time zone converter

### Ergonomics
- Coliving usually has good setup
- Airbnbs vary wildly
- Consider portable laptop stand
- External keyboard helps

### Backup Plans
- Know nearest coworking
- Save cafe WiFi passwords
- Have mobile data ready
- Identify hotel lobbies as fallback
