# Climate & Microclimates — Tenerife

## The Unique Climate

Tenerife has more microclimates than almost anywhere its size. You can drive 30 minutes and feel like you've changed continents.

### Why So Varied
- **Mount Teide** (3,718m) divides island
- **Trade winds** bring moisture from northeast
- **Altitude** creates temperature zones
- **Rain shadow** keeps south dry

---

## Climate Zones

### South Coast (Costa Adeje, Los Cristianos, El Médano)

**Character**: Desert-like, reliable sunshine

| Month | High °C | Low °C | Rain Days | Sea °C |
|-------|---------|--------|-----------|--------|
| Jan | 21 | 15 | 3 | 20 |
| Feb | 22 | 15 | 2 | 19 |
| Mar | 23 | 16 | 2 | 19 |
| Apr | 24 | 17 | 1 | 20 |
| May | 25 | 18 | 0 | 20 |
| Jun | 27 | 20 | 0 | 21 |
| Jul | 29 | 22 | 0 | 22 |
| Aug | 30 | 23 | 0 | 23 |
| Sep | 29 | 22 | 1 | 24 |
| Oct | 27 | 21 | 3 | 23 |
| Nov | 24 | 18 | 4 | 22 |
| Dec | 22 | 16 | 4 | 21 |

**What to expect**: 
- 320+ sunny days per year
- Very little rain (< 100mm annual)
- Warmest area in winter
- Hot but dry in summer
- Swimable year-round

### North Coast (Puerto de la Cruz, La Orotava)

**Character**: Subtropical, green, trade wind influence

| Month | High °C | Low °C | Rain Days | Sea °C |
|-------|---------|--------|-----------|--------|
| Jan | 20 | 14 | 6 | 20 |
| Feb | 20 | 14 | 5 | 19 |
| Mar | 21 | 14 | 5 | 19 |
| Apr | 22 | 15 | 3 | 19 |
| May | 23 | 16 | 2 | 20 |
| Jun | 25 | 18 | 1 | 21 |
| Jul | 27 | 20 | 0 | 22 |
| Aug | 28 | 21 | 1 | 23 |
| Sep | 27 | 21 | 2 | 24 |
| Oct | 25 | 19 | 5 | 23 |
| Nov | 23 | 17 | 6 | 22 |
| Dec | 21 | 15 | 7 | 21 |

**What to expect**:
- Cloud caps common (panza de burro)
- Often clears by afternoon
- More humidity
- Greener, lush vegetation
- Pleasant temperatures always

### Capital Area (Santa Cruz, La Laguna)

**Character**: Mild, urban, cooler at altitude

**Santa Cruz** (sea level):
- Similar to north coast
- Slightly drier than Puerto

**La Laguna** (550m):
- 3-5°C cooler than coast
- More cloud/mist
- Can feel damp in winter
- Jacket often needed evenings

### Mountains (Teide, Vilaflor)

**Character**: Alpine at peak, pine forest zone below

| Altitude | Summer | Winter |
|----------|--------|--------|
| 1,000m | 20-25°C | 10-15°C |
| 2,000m | 15-20°C | 5-10°C |
| 3,000m+ | 10-15°C | -5 to 5°C |

**What to expect**:
- Snow on Teide summit (Dec-Mar)
- Pine forests from 1,000-2,000m
- Very sunny above cloud line
- Cold nights, warm days
- Wind can be fierce

### East Coast (El Médano, Granadilla)

**Character**: Sunny but windy

- Similar temps to south coast
- Wind almost constant
- Great for water sports
- Less humid than rest of island

---

## Monthly Guide

### January-February
- **South**: Perfect, 20-23°C, sunny
- **North**: Pleasant, occasional showers, 18-20°C
- **Mountains**: Cold, possible snow on Teide
- **Best for**: Escaping northern European winter, hiking

### March-April
- **South**: Warming, very dry, 22-25°C
- **North**: Clearing, wildflowers, 20-22°C
- **Mountains**: Snow melting, great hiking
- **Best for**: Hiking, before summer crowds

### May-June
- **South**: Hot starting, 25-28°C
- **North**: Lovely, 22-25°C
- **Sea**: Warming nicely
- **Best for**: Beach, outdoor activities

### July-August
- **South**: Hot, 28-32°C, tolerable (dry heat)
- **North**: Warm, 25-28°C
- **Sea**: Warmest (23-24°C)
- **Warning**: Calima (Saharan dust) possible
- **Best for**: Beach, water sports

### September-October
- **South**: Still warm, 26-29°C
- **North**: Perfect, 24-27°C
- **Sea**: Peak warmth
- **Best for**: Best overall month, sea warmest

### November-December
- **South**: Pleasant, 22-24°C
- **North**: Mild, occasional rain, 20-22°C
- **Mountains**: Getting cold
- **Best for**: Avoiding crowds, still warm enough

---

## Weather Phenomena

### Panza de Burro (Cloud Cap)
- Sea of clouds sitting on north at 800-1,500m
- South sunny while north cloudy
- Often clears by afternoon
- Teide pokes above dramatically

### Calima (Saharan Dust)
- Wind from Africa brings sand/dust
- Hazy skies, reduced visibility
- Can affect breathing for sensitive
- Usually few days at a time
- Most common July-August

### Trade Winds
- Northeast winds (alisios)
- Constant, cooling
- Drive north moisture
- Make El Médano windy

### Temporal de Sur
- Rare southern storms
- Can bring heavy rain
- Usually brief (1-2 days)
- Most likely Oct-Dec

---

## What to Pack

### Year-Round Essentials
- Sunglasses
- Sunscreen (SPF 50+)
- Light layers
- Comfortable walking shoes

### For North/Mountains
- Light jacket or sweater
- Long pants option
- Rain jacket (Oct-Feb especially)

### For South/Beach
- Swimwear
- Beach cover-up
- Sandals
- Hat

### For Teide
- Warm layers (fleece/jacket)
- Closed shoes
- Sunglasses (essential)
- Sun protection (UV intense at altitude)

---

## Climate Comparison

### vs Other Destinations

| Location | Winter Low | Summer High | Annual Rain |
|----------|------------|-------------|-------------|
| Tenerife South | 15°C | 30°C | 100mm |
| Tenerife North | 14°C | 28°C | 350mm |
| Barcelona | 4°C | 30°C | 600mm |
| Lisbon | 8°C | 30°C | 700mm |
| London | 2°C | 24°C | 600mm |
| Berlin | -2°C | 25°C | 570mm |
| Miami | 15°C | 33°C | 1,570mm |

### Key Advantages
- No real winter
- No extreme heat (dry)
- Swimable year-round
- Escape to mountains if too hot
- Multiple climates to choose from

---

## Best Time to Visit

| Priority | Best Months |
|----------|-------------|
| Beach (guaranteed sun) | May-October |
| Beach (fewer crowds) | May-June, September |
| Hiking | March-May, October-November |
| Avoiding crowds | May, October-November |
| Budget | May-June, October-November |
| Whale watching | Year-round (peak Dec-Feb) |
| Festivals | February (Carnival), June (Corpus Christi) |
| Christmas sun | December (book far ahead) |
