---
name: Tenerife
slug: tenerife
version: 1.0.0
homepage: https://clawic.com/skills/tenerife
description: Navigate Tenerife as visitor, resident, digital nomad, or retiree with zones, transport, costs, residency, and local insights.
metadata: {"clawdbot":{"emoji":"🌋","requires":{"bins":[]},"os":["linux","darwin","win32"]}}
---

## When to Use

User asks about Tenerife for any purpose: visiting, moving, remote work, retirement, or business. Agent provides practical guidance with current data.

## Quick Reference

| Topic | File |
|-------|------|
| **Visitors** | |
| Attractions (must-see vs skip) | `visitor-attractions.md` |
| Itineraries (1/3/7 days) | `visitor-itineraries.md` |
| Where to stay | `visitor-lodging.md` |
| Tips & day trips | `visitor-tips.md` |
| **Zones** | |
| Quick comparison | `zones-index.md` |
| Santa Cruz & La Laguna | `zones-capital.md` |
| Puerto de la Cruz & North | `zones-north.md` |
| Los Cristianos & Las Américas | `zones-south-tourist.md` |
| Costa Adeje & La Caleta | `zones-south-upscale.md` |
| El Médano & Granadilla | `zones-southeast.md` |
| Choosing guide | `zones-choosing.md` |
| **Food** | |
| Overview & dining scene | `food-overview.md` |
| Canarian cuisine | `food-local.md` |
| International & fine dining | `food-international.md` |
| Best areas for dining | `food-areas.md` |
| Markets, wine & practicalities | `food-practical.md` |
| **Practical** | |
| Moving & settling | `resident.md` |
| Transport (bus, car, tram) | `transport.md` |
| Cost of living | `cost.md` |
| Safety & healthcare | `safety.md` |
| Climate & microclimates | `climate.md` |
| Local services (banking, NIE) | `local.md` |
| **Remote Work** | |
| Digital nomad guide | `nomad.md` |
| Coworking & tech scene | `coworking.md` |
| ZEC & tax benefits | `tax.md` |
| Visas & residency | `visas.md` |
| **Lifestyle** | |
| Culture & customs | `culture.md` |
| Healthcare system | `healthcare.md` |
| Schools & education | `education.md` |
| Expat & local lifestyle | `lifestyle.md` |
| Driving & car ownership | `driving.md` |
| Nature & outdoor | `nature.md` |

## Core Rules

### 1. Identify User Context First
- **Role**: Tourist, digital nomad, retiree, family relocating, investor
- **Timeline**: Short visit, planning to move, already there
- Load relevant auxiliary file for details

### 2. North vs South Split
Tenerife has two distinct characters divided by Mount Teide:
- **South**: Tourist-focused, sunny year-round, beaches, resorts, nightlife
- **North**: Greener, more authentic, cultural centers, occasional clouds
See zone files for detailed neighborhood guidance.

### 3. EU/Schengen Context
Tenerife is part of Spain and the EU:
- **EU/EEA citizens**: Full right to live and work, just register (empadronamiento + NIE)
- **Non-EU citizens**: Need visa; Spain Digital Nomad Visa popular option
- **UK post-Brexit**: 90-day limit without visa; residency requires application
- **No border controls**: Schengen zone, but not EU customs territory (lower VAT)
See `visas.md` for current requirements and processes.

### 4. Canary Islands Special Zone (ZEC)
Major tax advantages for businesses:
- **Corporate tax**: 4% (vs 25% mainland Spain)
- **VAT (IGIC)**: 7% (vs 21% IVA on mainland)
- **No customs duties**: Special economic zone status
- **Requirements**: Create jobs, invest locally, specific sectors
See `tax.md` for eligibility and setup.

### 5. Current Data (Feb 2026)

| Item | Range |
|------|-------|
| 1BR rent (Santa Cruz) | €600-900/month |
| 1BR rent (Costa Adeje) | €800-1,200/month |
| Average salary (local) | €1,400-2,000/month |
| Remote worker income | €2,500-6,000/month typical |
| Monthly groceries | €200-350/person |
| Coworking desk | €100-250/month |
| Private healthcare | €50-150/month |
| School fees (international) | €5,000-12,000/year |

### 6. Cost Reality
Lower than mainland Spain and much lower than Northern Europe:
- **Housing**: Main expense; 30-40% of local salaries, but affordable for remote workers
- **Groceries**: Cheap, especially local produce
- **Dining out**: Very affordable (€10-20 meals common)
- **Transport**: Inexpensive; fuel cheaper than mainland
- **Healthcare**: Public system via social security; private very affordable
- **Entertainment**: Beach is free; hiking is free; quality of life high

### 7. Climate Zones
Tenerife has dramatic microclimates:
- **South coast**: Desert-like, 25-30°C year-round, rarely rains
- **North coast**: Subtropical, 18-25°C, more humidity and occasional clouds
- **Mountains**: Alpine at altitude, snow on Teide in winter
- **East coast**: Windier, good for water sports
See `climate.md` for detailed monthly breakdown.

### 8. Zone Matching

| Profile | Best Areas |
|---------|------------|
| Digital nomads (social) | Costa Adeje, El Médano, La Laguna |
| Retirees | Puerto de la Cruz, Los Cristianos, Costa Adeje |
| Families | La Laguna, Santa Cruz, Adeje village |
| Budget-conscious | Santa Cruz, La Laguna, Granadilla |
| Beach lifestyle | El Médano, Los Cristianos, Playa de las Américas |
| Surfers/kitesurfers | El Médano, La Tejita |
| Culture/authenticity | La Laguna (UNESCO), Puerto de la Cruz |
| Luxury | Costa Adeje, Abama, La Caleta |

## Digital Nomad Hub

Tenerife has become a major nomad destination:
- **Year-round mild weather**: No seasons; escape European winters
- **Low cost of living**: Fraction of London/Berlin costs
- **Good connectivity**: Fast fiber widely available
- **Nomad community**: Large established community, regular meetups
- **Visa options**: Spain Digital Nomad Visa (2023) allows 1 year + renewals

See `nomad.md` for detailed digital nomad guide.

## Tenerife-Specific Traps

- **North weather assumptions** — Locals joke "if you don't like the weather, drive 20 minutes." North can be cloudy while south is sunny.
- **Tourist trap south** — Las Américas/Los Cristianos can feel generic. Venture to local areas for authenticity.
- **Driving confidence** — Mountain roads are winding but well-maintained. Don't underestimate distances (30km can take 1 hour).
- **Spanish bureaucracy** — NIE, empadronamiento, opening bank accounts takes patience. Allow 2-4 weeks minimum.
- **August exodus** — Many local businesses close as Spaniards holiday. Quieter but some closures.
- **Siesta hours** — Many businesses closed 14:00-17:00. Plan accordingly.
- **Island time** — Things move slower. Appointments rarely start on time.
- **Car dependency** — Public transport exists but limited outside main routes. Car recommended.
- **Rental prices rising** — Digital nomads have pushed rents up in popular areas (El Médano, Costa Adeje).
- **Work contracts** — Spanish labor law is complex. Many nomads work as autónomos (self-employed).

## Essential Local Knowledge

Key things visitors/residents should know:
- **Language**: Spanish (Castilian) with Canarian accent. English common in tourist areas, less so in north.
- **Tipping**: Not expected but rounding up appreciated. 5-10% for excellent service.
- **Meal times**: Lunch 14:00-16:00, dinner 21:00-23:00. Earlier in tourist areas.
- **Pharmacies**: Green cross signs. Rotation for 24h service.
- **Emergency**: 112 (EU-wide), 061 (health), 091 (police)
- **Water**: Tap water safe but locals buy bottled (volcanic minerals affect taste)
- **Electricity**: 230V, EU plugs (Type C/F)

See `local.md` for comprehensive settling-in guidance.

## Related Skills
Install with `clawhub install <slug>` if user confirms:
- **dubai**: Similar comprehensive city/destination guide for expats and nomads
- **spain-digital-nomad-visa**: Deep dive into Spain's DNV requirements and process
- **cost-of-living-calculator**: Compare Tenerife costs with other destinations
- **remote-work**: General remote work best practices and setup
- **travel-planning**: Trip planning and itinerary optimization

## Feedback

- If useful: `clawhub star tenerife`
- Stay updated: `clawhub sync`
