---
name: tencentcloud-lighthouse-skill
description: Manage Tencent Cloud Lighthouse (轻量应用服务器) — auto-setup mcporter + MCP, query instances, monitoring & alerting, self-diagnostics, firewall, snapshots, remote command execution (TAT). Use when user asks about Lighthouse or 轻量应用服务器. NOT for CVM or other cloud server types.
metadata:
  {
    "openclaw":
      {
        "emoji": "☁️",
        "requires": {},
        "install":
          [
            {
              "id": "node-mcporter",
              "kind": "node",
              "package": "mcporter",
              "bins": ["mcporter"],
              "label": "Install mcporter (MCP CLI)",
            },
          ],
      },
  }
---

# Lighthouse 云服务器运维

通过 mcporter + lighthouse-mcp-server 管理腾讯云轻量应用服务器。

## 首次使用 — 自动设置

当用户首次要求管理云服务器时，按以下流程操作：

### 步骤 1：检查当前状态

```bash
{baseDir}/scripts/setup.sh --check-only
```

如果输出显示一切 OK（mcporter 已安装、config 已配置、lighthouse 已就绪），跳到「调用格式」。

### 步骤 2：如果未配置，引导用户提供密钥

告诉用户：
> 我需要你的腾讯云 API 密钥来连接 Lighthouse 服务器。请提供：
> 1. **SecretId** — 腾讯云 API 密钥 ID
> 2. **SecretKey** — 腾讯云 API 密钥 Key
>
> 你可以在 [腾讯云控制台 > 访问管理 > API密钥管理](https://console.cloud.tencent.com/cam/capi) 获取。

### 步骤 3：用户提供密钥后，运行自动设置

```bash
{baseDir}/scripts/setup.sh --secret-id "<用户提供的SecretId>" --secret-key "<用户提供的SecretKey>"
```

脚本会自动：
- 检查并安装 mcporter（如未安装）
- 创建 `~/.mcporter/mcporter.json` 配置文件
- 写入 lighthouse MCP 服务器配置和密钥
- 验证连接

设置完成后即可开始使用。

## 调用格式

所有 mcporter 命令必须使用以下格式：

```
mcporter call lighthouse.<tool_name> --config ~/.mcporter/mcporter.json --output json [--args '<JSON>']
```

列出可用工具：
```
mcporter list lighthouse --config ~/.mcporter/mcporter.json --schema
```


## 工具总览

本 MCP Server 包含以下工具类别：

| 类别 | 说明 |
|------|------|
| 地域查询 | 获取可用地域列表（唯一不需要 Region 参数的操作） |
| 实例管理 | 查询、启动实例，查看流量包/套餐/配额等（需要 Region） |
| 监控与告警 | 获取多指标监控数据、设置告警策略、服务器自检（需要 Region） |
| 防火墙 | 规则增删改查、防火墙模板管理（需要 Region） |
| 远程命令(TAT) | 在实例上执行命令、查询任务状态（需要 Region） |

## 常用操作

> 以下所有示例省略了公共前缀 `mcporter call lighthouse.` 和 `--config ~/.mcporter/mcporter.json --output json`。
> 完整命令格式：`mcporter call lighthouse.<tool_name> --config ~/.mcporter/mcporter.json --output json --args '<JSON>'`

### 获取地域列表（不需要 Region 参数）

```bash
# 查询所有可用地域 — 唯一不需要 Region 参数的操作
# 首次使用时应先调用此接口获取可用 Region 列表
mcporter call lighthouse.describe_regions --config ~/.mcporter/mcporter.json --output json
```

### 实例管理

```bash
# 查询实例列表（Region 必填，可选参数: InstanceIds, Offset, Limit）
mcporter call lighthouse.describe_instances --config ~/.mcporter/mcporter.json --output json --args '{"Region":"ap-guangzhou","Limit":20,"Offset":0}'

# 查询指定实例
mcporter call lighthouse.describe_instances --config ~/.mcporter/mcporter.json --output json --args '{"Region":"ap-guangzhou","InstanceIds":["lhins-xxxxxxxx"]}'

# 启动实例
mcporter call lighthouse.start_instances --config ~/.mcporter/mcporter.json --output json --args '{"Region":"ap-guangzhou","InstanceIds":["lhins-xxxxxxxx"]}'

# 获取实例登录终端地址
mcporter call lighthouse.describe_instance_login_url --config ~/.mcporter/mcporter.json --output json --args '{"Region":"ap-guangzhou","InstanceId":"lhins-xxxxxxxx"}'

# 查询所有应用镜像
mcporter call lighthouse.describe_all_applications --config ~/.mcporter/mcporter.json --output json --args '{"Region":"ap-guangzhou"}'
# BlueprintType 可选: APP_OS | PURE_OS | DOCKER | ALL（默认ALL）
```

### 监控与告警

```bash
# 获取监控数据（支持多指标同时查询，默认最近6小时）
mcporter call lighthouse.get_monitor_data --config ~/.mcporter/mcporter.json --output json --args '{"Region":"ap-guangzhou","InstanceId":"lhins-xxxxxxxx","Indicators":["CPU利用率","内存利用率"]}'

# 获取监控数据（指定时间范围）
mcporter call lighthouse.get_monitor_data --config ~/.mcporter/mcporter.json --output json --args '{"Region":"ap-guangzhou","InstanceId":"lhins-xxxxxxxx","Indicators":["公网出带宽","公网入带宽"],"StartTime":"2026-02-09 00:00:00","EndTime":"2026-02-10 00:00:00"}'

# 支持的监控指标（中文名称）:
# CPU利用率 | 内存利用率 | 公网出带宽 | 公网入带宽
# 系统盘读IO | 系统盘写IO | 公网流量包

# 设置告警策略
# Alarms 中的 Frequency/Points/Size 均为字符串类型
mcporter call lighthouse.set_alerting_strategy --config ~/.mcporter/mcporter.json --output json --args '{"Region":"ap-guangzhou","InstanceId":"lhins-xxxxxxxx","Indicator":"CPU利用率","Alarms":[{"Frequency":"300","Threshold":"80%","Level":"严重","Points":"3","Size":"60"}],"PolicyName":"CPU高负载告警"}'
# Frequency(秒): "300"|"600"|"900"|"1800"|"3600"|"7200"|"10800"|"21600"|"43200"|"86400"
# Level: "提示"|"严重"|"紧急"    Points: "1"-"5"    Size: "60"|"300"

# 服务器自检（检测网络、防火墙、存储、状态、性能）
mcporter call lighthouse.self_test --config ~/.mcporter/mcporter.json --output json --args '{"Region":"ap-guangzhou","InstanceId":"lhins-xxxxxxxx"}'
```

### 防火墙

```bash
# 查询防火墙规则
mcporter call lighthouse.describe_firewall_rules --config ~/.mcporter/mcporter.json --output json --args '{"Region":"ap-guangzhou","InstanceId":"lhins-xxxxxxxx"}'

# 添加防火墙规则
mcporter call lighthouse.create_firewall_rules --config ~/.mcporter/mcporter.json --output json --args '{"Region":"ap-guangzhou","InstanceId":"lhins-xxxxxxxx","FirewallRules":[{"Protocol":"TCP","Port":"8080","CidrBlock":"0.0.0.0/0","Action":"ACCEPT","FirewallRuleDescription":"开放8080端口"}]}'

# 删除防火墙规则
mcporter call lighthouse.delete_firewall_rules --config ~/.mcporter/mcporter.json --output json --args '{"Region":"ap-guangzhou","InstanceId":"lhins-xxxxxxxx","FirewallRules":[{"Protocol":"TCP","Port":"8080"}]}'
```

### 远程命令执行 (TAT)

```bash
# 在 Linux 实例上执行命令
mcporter call lighthouse.execute_command --config ~/.mcporter/mcporter.json --output json --args '{"Region":"ap-guangzhou","InstanceId":"lhins-xxxxxxxx","Command":"uptime && df -h && free -m","SystemType":"Linux"}'

# 在 Windows 实例上执行命令
mcporter call lighthouse.execute_command --config ~/.mcporter/mcporter.json --output json --args '{"Region":"ap-guangzhou","InstanceId":"lhins-xxxxxxxx","Command":"Get-Process | Sort-Object CPU -Descending | Select-Object -First 10","SystemType":"Windows"}'

# 查询命令执行任务详情（自动轮询直到完成）
mcporter call lighthouse.describe_command_tasks --config ~/.mcporter/mcporter.json --output json --args '{"Region":"ap-guangzhou","InvocationTaskId":"invt-xxxxxxxx"}'

# 注意: Command 最大 2048 字符，超长命令建议登录实例手动执行
```

## 使用规范

1. **每次调用必须带** `--config ~/.mcporter/mcporter.json`
2. **始终加** `--output json` 获取结构化输出
3. **Region 参数规则**: 除 `describe_regions` 外，所有操作都**必须**传入 `Region` 参数。如果用户未指定 Region，应先调用 `describe_regions` 获取可用地域列表，再让用户选择或根据上下文确定
4. **首次使用流程**: 先调用 `describe_regions` 获取地域列表 → 再调用 `describe_instances` 获取实例列表 → 记住 InstanceId 和 Region 供后续使用
5. **用实际的 InstanceId** 替换示例中的 `lhins-xxxxxxxx`（先通过 `describe_instances` 获取）
6. **监控指标用中文**: `get_monitor_data` 的 Indicators 参数使用中文名称（CPU利用率、内存利用率等）
7. **命令长度限制**: `execute_command` 的 Command 参数最大 2048 字符，超长建议登录实例执行
8. **危险操作前先确认**: 防火墙修改、命令执行、实例关机/重启等，先向用户确认
9. **错误处理**: 如果调用失败，先用 `{baseDir}/scripts/setup.sh --check-only` 诊断问题，或用 `self_test` 检测实例状态