# Scam Detection — Temu

## Types of Scams

### 1. Counterfeit Brands
**Pattern:** Brand-name items at impossible prices.

| If You See | Reality |
|------------|---------|
| Nike shoes for $15 | 100% counterfeit |
| Apple accessories for $3 | Fake/dangerous |
| Designer bags for $20 | Knockoff |
| Branded cosmetics 90% off | Potentially harmful |

**Rule:** If a brand item is >50% cheaper than retail, it's fake. No exceptions.

### 2. Bait-and-Switch
**Pattern:** Main listing photo differs from actual product.

**Detection:**
- Scroll through ALL product photos, not just hero image
- Check if product photos are consistent
- Read 1-star reviews for "not as pictured"
- Reverse image search main photo

### 3. Size Manipulation
**Pattern:** Sizes listed don't match reality.

**Detection:**
- Never trust S/M/L — check actual measurements
- Search reviews for "actual measurements"
- Assume Chinese sizing (1-2 sizes smaller than US/EU)
- Electronics: check voltage compatibility

### 4. Quality Bait
**Pattern:** Product looks premium in photos, arrives as garbage.

**Red flags:**
- Only professional/studio photos
- No buyer photos in reviews
- Material description is vague ("high-quality material")
- Price too low for claimed quality

### 5. Dropship Arbitrage
**Pattern:** Seller doesn't have product, orders from different supplier.

**Detection:**
- Seller has random unrelated products
- Stock photos only
- Very new store (<30 days)
- Shipping from unexpected country
- Long delays before tracking appears

## Detection Checklist

Before buying any item over $20:

```
□ Price compared to AliExpress/Amazon
□ Checked seller store age (>6 months)
□ Read 10+ photo reviews
□ Searched for "actual", "real", "warning" in reviews
□ Verified measurements against reviews
□ Checked if brand item = counterfeit risk
□ Reviewed return policy
□ Calculated true total cost
```

## Post-Purchase Protection

### Document Everything
1. Screenshot listing at time of purchase
2. Screenshot seller promises
3. Video unboxing (for disputes)
4. Photos of any defects immediately

### Dispute Timing
- Report issues within 90 days
- Open dispute BEFORE protection expires
- Escalate if seller doesn't respond in 48h
- Temu generally sides with buyer on documented cases

### Red Flags Post-Purchase
- Tracking number doesn't work
- Tracking shows "delivered" but nothing arrived
- Item significantly differs from listing
- Seller asks to "close dispute for partial refund"

## High-Risk Categories

| Category | Scam Risk | Why |
|----------|-----------|-----|
| Brand anything | VERY HIGH | Counterfeits |
| Electronics | HIGH | Safety, compatibility |
| Cosmetics | HIGH | Ingredients unknown |
| "Medical" devices | EXTREME | Safety hazard |
| Car parts | HIGH | Safety critical |
| Supplements | EXTREME | Not regulated |

## Low-Risk Categories

| Category | Why Safer |
|----------|-----------|
| Generic decor | No brand to fake |
| Party supplies | Low stakes |
| Basic tools | Obvious quality |
| Phone cases | Easy to assess |
| Stationery | What you see = what you get |
