# Review Analysis — Temu

## Identifying Fake Reviews

### Red Flags (Likely Fake)
- Generic praise: "Great product!", "Love it!", "Fast shipping!"
- Posted within 24-48h of product listing
- Perfect grammar + no specific details
- Same review text across multiple products
- Reviewer has only 5-star reviews
- Stock photos or no photos at all

### Green Flags (Likely Real)
- Mentions specific measurements: "fits like medium US, not large as listed"
- Shows product in real environment (not studio shot)
- Notes both pros AND cons
- Includes comparison to expectations
- Reviewer has mixed rating history

## Review Analysis Workflow

### Step 1: Filter
1. Sort by "with photos" only
2. Focus on 3-4 star reviews (most honest)
3. Search keywords: "actual", "real", "true to size", "warning"

### Step 2: Check Consistency
Compare what reviews say about:
- Actual size vs listed size
- Material quality vs description
- Color accuracy vs photos
- Durability after use

### Step 3: Red Flag Keywords
```
"Not as pictured" → expect different product
"Smaller than expected" → size runs small
"Cheap material" → ignore "premium" claims
"Fell apart" → poor durability
"Smells like chemicals" → potential safety issue
```

## Minimum Thresholds

| Risk Level | Orders | Rating | Photo Reviews |
|------------|--------|--------|---------------|
| Low risk (decor, basic) | 100+ | 4.0+ | 10+ |
| Medium risk (clothing) | 500+ | 4.3+ | 50+ |
| High risk (electronics) | 1000+ | 4.5+ | 100+ |

Items below these thresholds: proceed with extreme caution or skip.

## Photo Review Analysis

### What to Look For
- **Lighting**: Real home lighting vs. studio = more trustworthy
- **Backgrounds**: Varied backgrounds = multiple real buyers
- **Quality**: Slightly blurry phone photos = authentic
- **Angles**: Multiple angles of same item = thorough buyer
- **Wear photos**: After 1 month photos = durability proof

### What to Avoid
- Identical angles across reviews
- Professional-looking product shots
- Photos that match listing exactly
- No context (floating product on white)
