# Pricing Strategies — Temu

## Understanding Temu Pricing

### The "Discount" Illusion
Temu's "original prices" are fictional. A "$100 → $15" item was never $100.

**Reality check method:**
1. Search same product on AliExpress
2. Check Amazon/eBay for similar items
3. Google image search the product
4. True "discount" = difference from other platforms, not from listed original

### Price Fluctuation Patterns

| Pattern | When | Strategy |
|---------|------|----------|
| Flash sales | Multiple times daily | Check every few hours for target items |
| New user coupons | First 7-30 days | Stack with flash sales for max discount |
| Category promotions | Rotate weekly | Wait for your category's turn |
| Holiday sales | Major holidays | Often best yearly prices |
| Random drops | Unpredictable | Track wishlist items |

## Coupon Stacking

### Types of Coupons
1. **Welcome coupons** — New users, biggest discounts
2. **Order total coupons** — "10% off $50+"
3. **Category coupons** — "15% off Home & Garden"
4. **Shipping coupons** — Free shipping thresholds
5. **Daily check-in** — Small discounts for app engagement

### Optimal Stacking Order
```
Base price
  └─ Category coupon (if applicable)
    └─ Order total coupon
      └─ Shipping discount
        └─ Payment method bonus (if any)
```

### Free Shipping Thresholds
Typical thresholds (vary by region):
- $20-30 minimum for standard
- $50+ for "express"

**Strategy:** Batch orders to hit threshold; small single-item orders lose value to shipping.

## Cross-Platform Price Comparison

### When Temu Wins
- Generic/unbranded items (often 50-80% cheaper)
- Trendy fashion items
- Home decor, party supplies
- Phone cases, accessories

### When Temu Loses
- Brand items (counterfeits don't count)
- Items needed urgently (Amazon Prime wins)
- Heavy items (shipping kills savings)
- Items with warranty needs

### Total Cost Formula
```
True cost = Temu price 
          + shipping (if under threshold)
          + customs duties (region-dependent)
          + time cost (3-4 weeks wait)
          + return risk (often unreturnable)
```

## Seasonal Timing

| Event | Typical Discount | Best For |
|-------|------------------|----------|
| Chinese New Year | 30-50% | Plan ahead (shipping delays!) |
| 11.11 Singles Day | 40-60% | Best yearly prices |
| Black Friday | 30-40% | Good, not best |
| Summer sales | 20-30% | Seasonal clearance |

**Warning:** Shipping during major Chinese holidays can add 2-3 weeks delay.
