# telegram-voice-group 使用案例

## 基础功能
- 向 Telegram 群组发送语音消息
- 支持向特定话题发送语音消息
- 文本格式清洗，避免朗读出格式标记

## 高级应用

### 1. 社交媒体信息聚合
- 搜索 Reddit 和 Twitter 上的热门话题
- 总结信息内容
- 生成语音摘要并发送到指定群组话题

**示例流程：**
1. 使用 `web_fetch` 获取 Reddit RSS 数据
2. 使用 `bird` CLI 搜索 Twitter 话题
3. 整理和总结收集到的信息
4. 使用 `edge-tts` 和 `ffmpeg` 生成语音
5. 通过 `message` 工具发送到指定群组话题

### 2. 话题管理
- 使用 `threadId` 参数精确控制消息发送的话题
- 保持群组讨论的组织性和条理性
- 支持在不同话题间切换和发送消息

## 技术要点

### 语音生成最佳实践
- 使用 `zh-CN-XiaoxiaoNeural` 声线获得自然中文发音
- 设置 `+5%` 语速优化听取体验
- 使用 `libopus` 编码确保 Telegram 兼容性

### 消息发送参数
- `asVoice: true` - 确保语音以气泡形式显示
- `threadId` - 指定目标话题ID
- `media` - 指定语音文件路径

## 集成示例

结合 OpenClaw 生态系统中的其他工具，可以构建自动化的信息聚合和发布流程，如定期收集技术社区动态并分享到相关群组。