# 🤖 Telegram Voice Group 技能 for OpenClaw

📢 向指定 Telegram 群组和话题发送语音气泡消息的 OpenClaw 技能，支持上下文隔离和多模型配置。

## 📋 概述

这个技能允许 OpenClaw 助理向 Telegram 群组和话题发送语音消息，实现类似 Discord 服务器的多频道功能。通过 Telegram 话题功能，您可以创建多个独立的讨论区域，每个区域都有独立的上下文和可配置的 AI 模型。

## ✨ 主要功能

- **📢 语音气泡发送**：向 Telegram 群组和话题发送真正的语音气泡消息（非音频文件）
- **🗂️ 话题上下文隔离**：每个话题都有独立的会话上下文，互不干扰
- **🧠 多模型配置**：可在不同话题中设置不同的 AI 模型
- **🔄 Discord 替代方案**：利用 Telegram 话题功能实现类似 Discord 频道的组织结构
- **🧹 自动文本清洗**：自动移除 Markdown 标记、URL 和特殊符号，确保朗读效果

## 🚀 部署到 Telegram 群组完整教程

### 1. 🆕 创建 Telegram 群组
- 打开 Telegram 应用
- 点击右上角的 "+" 按钮
- 选择 "新建群组" 或 "New Group"
- 添加成员并设置群组名称和头像

### 2. 🤖 邀请 OpenClaw Bot 到群组
- 在群组中点击群组名称进入群组信息页面
- 点击 "添加成员" 或 "Add Member"
- 搜索并选择你的 OpenClaw Bot（例如 @your_openclaw_bot）
- 点击 "添加" 或 "Add"

### 3. ⚡ 赋予 OpenClaw Bot 群组管理权限
- 在群组信息页面，点击 OpenClaw Bot 的用户名
- 选择 "提升为管理员" 或 "Promote to Admin"
- 授予以下权限：
  - 删除消息 (Delete Messages)
  - 编辑群组信息 (Edit Group Info)
  - 发送消息 (Send Messages)
  - 发送媒体 (Send Media)
  - 限制成员 (Restrict Members)
  - 封禁成员 (Ban Members)
  - 添加管理员 (Add Admins) - 可选，根据需要

### 4. 🔢 获取群组的链接和 ID
- 点击群组头像进入群组信息页面
- 点击 "群组类型" 或 "Group Type" 下方的 "群组链接" 或 "Group Link"
- 复制群组链接（例如 https://t.me/your_group_name）
- 群组 ID 通常是链接后面的部分，或者在某些客户端可以直接看到数字 ID

### 5. 🗂️ 创建话题并获取话题序号
- 在群组中，点击底部的 "+" 按钮
- 选择 "新建话题" 或 "Create Topic"（如果群组启用了话题功能）
- 设置话题名称
- 点击话题头像进入话题详情
- 查看邀请链接，链接末尾的数字即为话题序号（例如 https://t.me/your_group_name/123 中的 123）

### 6. ⚙️ 在 OpenClaw 中配置群组和话题
- 将群组链接和 ID 发送给 OpenClaw Bot
- 将话题序号发送给 OpenClaw Bot
- 使用如下命令格式发送语音消息：
  ```
  向 agent:main:telegram:group:[GROUP_ID]:topic:[TOPIC_ID] 发送语音: 你的语音内容
  ```

## 🗂️ 话题功能详解

### 🔄 完全替代 Discord 的能力
- **🗂️ 话题独立上下文**：每个 Telegram 话题都有独立的会话上下文，格式为 `agent:main:telegram:group:{groupId}:topic:{threadId}`
- **🔒 会话隔离**：不同话题间的对话历史和上下文完全隔离，互不干扰
- **🧠 模型独立设置**：可以在不同的话题中设置不同的 AI 模型
- **📋 上下文独立**：每个话题维护自己的对话历史，就像 Discord 的不同频道一样

### 🧠 在不同话题中设置不同模型
- 通过 OpenClaw 的会话管理功能，可以为每个话题（`agent:main:telegram:group:{groupId}:topic:{threadId}`）单独配置 AI 模型
- 每个话题的上下文完全独立，不会相互影响
- 支持多话题并行运行，每个话题可以有不同的功能和配置

## 📦 安装

```bash
openclaw skills install telegram-voice-group
```

## 🔧 依赖

- `edge-tts` - 用于生成语音
- `ffmpeg` - 用于格式转换

## 🛠️ 使用方法

### 1. 直接在会话中使用此功能：

"向 {群组会话键} 发送语音: {语音内容}"

例如:
"向 agent:main:telegram:group:[GROUP_ID]:topic:[TOPIC_ID] 发送语音: 大家好，我是[ASSISTANT_NAME]，[NICKNAME]的AI助理。很高兴在[MOLTBOT_COMMUNITY]社区与大家见面，祝大家交流愉快！"

### 2. 通过 sessions_spawn 调用：

```js
await sessions_spawn({
  task: "向 agent:main:telegram:group:[GROUP_ID]:topic:[TOPIC_ID] 发送语音: 这是一条测试消息",
  agentId: "telegram-voice-group"
})
```

### 3. 直接调用函数（在JS环境中）：

```js
const { sendVoiceToTelegramGroup } = require('./index.js');
await sendVoiceToTelegramGroup({
  text: "语音内容",
  groupId: "agent:main:telegram:group:[GROUP_ID]:topic:[TOPIC_ID]",
  voice: "zh-CN-XiaoxiaoNeural",
  rate: "+5%"
});
```

## ⚙️ 技术规范

- 生成 MP3 格式临时音频
- 使用 FFmpeg 转换为 Telegram 兼容的 OGG Opus 格式
- 音频参数：libopus编码，48k比特率，单声道，48kHz采样率，VOIP应用类型
- 使用 `asVoice: true` 参数确保以语音气泡形式发送，而非文件
- 自动清理临时文件
- 文本格式清洗：自动移除 Markdown 标记、URL 链接和特殊符号，避免朗读出标记符号

## 📄 许可证

MIT License