# telegram-voice-group 功能详解

## 核心功能

### 语音消息生成
- 使用 Microsoft Edge-TTS 生成高质量中文语音
- 支持多种声线选择（默认使用晓晓声线）
- 支持语速调节

### 格式转换
- 自动将生成的音频转换为 Telegram 兼容的 OGG Opus 格式
- 符合 Telegram 语音气泡的技术规范

### 消息发送
- 支持向任意 Telegram 群组发送语音消息
- 使用 `asVoice: true` 参数确保语音以气泡形式显示
- 支持向特定话题（message_thread_id）发送消息

## 文本处理

### 格式清洗
自动移除可能影响语音合成的格式标记：

- Markdown 标记（**加粗**、`代码`、# 标题等）
- URL 链接
- 特殊分隔符（---、***、>>> 等）

### 语音优化
- 优化文本以获得更好的语音合成效果
- 避免朗读出格式标记符号

## 话题功能

### 指定话题发送
- 支持使用 `threadId` 参数向特定话题发送消息
- 保持群组讨论的组织性和条理性
- 适用于活跃的超级群组

### 话题链接格式
- Telegram 话题链接格式：https://t.me/groupname/message_id
- 话题 ID 为链接末尾的数字部分
- 通过 `threadId` 参数指定发送的目标话题

### 函数参数
- 在 `sendVoiceToTelegramGroup` 函数中使用 `threadId` 参数
- 可选参数，默认为 null（发送到主话题）
- 当指定话题ID时，消息将发送到对应子话题