---
name: telegram-pairing-approver
description: 创建一个持久运行的Telegram机器人服务，用于自动处理配对代码并批准Telegram会话权限。使用时提供机器人令牌，自动创建机器人脚本和服务文件，并启动系统服务。适用于需要自动处理Telegram配对请求的场景。
---

# Telegram 配对代码自动批准机器人服务

## 快速开始

使用预构建的部署脚本快速创建服务：

```bash
node scripts/deploy.js <YOUR_BOT_TOKEN>
```

例如：
```bash
node scripts/deploy.js 9632389037:ADG3jTndsXpgdOrdJkfaV80nnsjhQyWEhbT
```

## 功能
- 自动识别三种配对代码格式：
  - `NDW4JDJ4` (纯代码格式)
  - `code: NDW4JDJ4` (带code:前缀)
  - `Pairing code: NDW4JDJ4` (带Pairing code:前缀)
- 自动执行 `openclaw pairing approve telegram <code>` 命令
- 发送友好的提示信息给用户
- 作为系统服务运行，具备自动重启功能

## 脚本说明

### 部署脚本 (`scripts/deploy.js`)
- 创建机器人脚本，自动注入提供的令牌
- 生成systemd服务文件
- 注册并启动系统服务
- 配置自动重启机制

## 服务管理

查看服务状态：
```bash
systemctl status telegram-pairing-bot.service
```

停止服务：
```bash
systemctl stop telegram-pairing-bot.service
```

重启服务：
```bash
systemctl restart telegram-pairing-bot.service
```

检查服务是否启用开机自启：
```bash
systemctl is-enabled telegram-pairing-bot.service
```

## 优势
- 高可用性：作为系统服务运行，具备自动重启能力
- 自动化：无需人工干预即可处理配对请求
- 用户友好：提供清晰的使用说明
- 可靠性：防止意外中断影响服务
- 易于部署：单命令完成完整部署