# Forum Topic Emoji IDs

Complete reference of valid `icon_custom_emoji_id` values for Telegram forum topics.

Obtained via `getForumTopicIconStickers` API method.

## Quick Reference

| Emoji | ID | Description |
|-------|-----|-------------|
| 📰 | `5434144690511290129` | Newspaper |
| 💡 | `5312536423851630001` | Light bulb |
| ⚡ | `5312016608254762256` | Lightning |
| 🎙 | `5377544228505134960` | Microphone |
| 🔝 | `5418085807791545980` | Top/up arrow |
| 🗣 | `5370870893004203704` | Speaking head |
| 🆒 | `5420216386448270341` | Cool button |
| ❗ | `5379748062124056162` | Exclamation |
| 📝 | `5373251851074415873` | Memo/notes |
| 📆 | `5433614043006903194` | Calendar |
| 📁 | `5357315181649076022` | Folder |
| 🔎 | `5309965701241379366` | Magnifying glass |
| 📣 | `5309984423003823246` | Megaphone |
| 🔥 | `5312241539987020022` | Fire |
| ❤️ | `5312138559556164615` | Heart |
| ❓ | `5377316857231450742` | Question mark |
| 📈 | `5350305691942788490` | Chart up |
| 📉 | `5350713563512052787` | Chart down |
| 💎 | `5309958691854754293` | Gem |
| 💰 | `5350452584119279096` | Money bag |
| 💸 | `5309929258443874898` | Money with wings |
| 🪙 | `5377690785674175481` | Coin |
| 💱 | `5310107765874632305` | Currency exchange |
| ⁉️ | `5377438129928020693` | Interrobang |
| 🎮 | `5309950797704865693` | Game controller |
| 💻 | `5350554349074391003` | Laptop |
| 📱 | `5409357944619802453` | Mobile phone |
| 🚗 | `5312322066328853156` | Car |
| 🏠 | `5312486108309757006` | House |
| 💘 | `5310029292527164639` | Heart with arrow |
| 🎉 | `5310228579009699834` | Party popper |
| ‼️ | `5377498341074542641` | Double exclamation |
| 🏆 | `5312315739842026755` | Trophy |
| 🏁 | `5408906741125490282` | Checkered flag |
| 🎬 | `5368653135101310687` | Clapperboard |
| 🎵 | `5310045076531978942` | Musical note |
| 🔞 | `5420331611830886484` | No one under 18 |
| 📚 | `5350481781306958339` | Books |
| 👑 | `5357107601584693888` | Crown |
| ⚽ | `5375159220280762629` | Soccer ball |
| 🏀 | `5384327463629233871` | Basketball |
| 📺 | `5350513667144163474` | Television |
| 👀 | `5357121491508928442` | Eyes |
| 🫦 | `5357185426392096577` | Biting lip |
| 🍓 | `5310157398516703416` | Strawberry |
| 💄 | `5310262535021142850` | Lipstick |
| 👠 | `5368741306484925109` | High heel |
| ✈️ | `5348436127038579546` | Airplane |
| 🧳 | `5357120306097956843` | Luggage |
| 🏖 | `5310303848311562896` | Beach |
| ⛅ | `5350424168615649565` | Partly cloudy |
| 🦄 | `5413625003218313783` | Unicorn |
| 🛍 | `5350699789551935589` | Shopping bags |
| 👜 | `5377478880577724584` | Handbag |
| 🛒 | `5431492767249342908` | Shopping cart |
| 🚂 | `5350497316203668441` | Train |
| 🛥 | `5350422527938141909` | Motor boat |
| 🏔 | `5418196338774907917` | Mountain |
| 🏕 | `5350648297189023928` | Camping |
| 🤖 | `5309832892262654231` | Robot |
| 🪩 | `5350751634102166060` | Mirror ball |
| 🎟 | `5377624166436445368` | Ticket |
| 🏴‍☠️ | `5386395194029515402` | Pirate flag |
| 🗳 | `5350387571199319521` | Ballot box |
| 🎓 | `5357419403325481346` | Graduation cap |
| 🔭 | `5368585403467048206` | Telescope |
| 🔬 | `5377580546748588396` | Microscope |
| 🎶 | `5377317729109811382` | Musical notes |
| 🎤 | `5382003830487523366` | Microphone |
| 🕺 | `5357298525765902091` | Man dancing |
| 💃 | `5357370526597653193` | Woman dancing |
| 🦖 | `5357188789351490453` | T-Rex |
| 💼 | `5348227245599105972` | Briefcase |
| 🧪 | `5411138633765757782` | Test tube |
| 👨‍👩‍👧‍👦 | `5386435923204382258` | Family |
| 👶 | `5377675010259297233` | Baby |
| 🤰 | `5386609083400856174` | Pregnant |
| 💅 | `5368808634392257474` | Nail polish |
| 🏛 | `5350548830041415279` | Classical building |
| 🧮 | `5355127101970194557` | Abacus |
| 🖨 | `5386379624773066504` | Printer |
| 👮‍♂️ | `5377494501373780436` | Police officer |
| 🩺 | `5350307998340226571` | Stethoscope |
| 💊 | `5310094636159607472` | Pill |
| 💉 | `5310139157790596888` | Syringe |
| 🧼 | `5377468357907849200` | Soap |
| 🪪 | `5418115271267197333` | ID card |
| 🛃 | `5372819184658949787` | Customs |
| 🍽 | `5350344462612570293` | Plate with cutlery |
| 🐟 | `5384574037701696503` | Fish |
| 🎨 | `5310039132297242441` | Art palette |
| 🎭 | `5350658016700013471` | Performing arts |
| 🎩 | `5357504778685392027` | Top hat |
| 🔮 | `5350367161514732241` | Crystal ball |
| 🍹 | `5350520238444126134` | Tropical drink |
| 🎂 | `5310132165583840589` | Birthday cake |
| ☕ | `5350392020785437399` | Coffee |
| 🍣 | `5350406176997646350` | Sushi |
| 🍔 | `5350403544182694064` | Hamburger |
| 🍕 | `5350444672789519765` | Pizza |
| 🦠 | `5312424913615723286` | Microbe |
| 💬 | `5417915203100613993` | Speech bubble |
| 🎄 | `5312054580060625569` | Christmas tree |
| 🎃 | `5309744892677727325` | Jack-o-lantern |
| ✍️ | `5238156910363950406` | Writing hand |
| ⭐ | `5235579393115438657` | Star |
| ✅ | `5237699328843200968` | Check mark |
| 🎖 | `5238027455754680851` | Military medal |
| 🤡 | `5238234236955148254` | Clown |
| 🧠 | `5237889595894414384` | Brain |
| 🧯 | `5237999392438371490` | Fire extinguisher |
| 🐈 | `5235912661102773458` | Cat |

## Usage

```bash
curl -X POST "https://api.telegram.org/bot<TOKEN>/editForumTopic" \
  -H "Content-Type: application/json" \
  -d '{
    "chat_id": <GROUP_ID>,
    "message_thread_id": <TOPIC_ID>,
    "icon_custom_emoji_id": "5312016608254762256"
  }'
```

## Notes

- Only these specific emoji IDs work as topic icons
- Using other custom emoji IDs will fail with `DOCUMENT_INVALID`
- Icons are animated stickers from the "Topics" sticker set
- To remove an icon, pass an empty string for `icon_custom_emoji_id`
