---
name: telegram-history
description: Fetch Telegram chat message history via MTProto user API (Telethon). Use when needing to read old messages from any Telegram chat, group, or forum topic that the bot API can't access. Supports fetching by chat ID, forum topic/thread, message count, pagination, and JSON output. Requires one-time user login with phone number + 2FA.
---

# Telegram History

Fetch message history from any Telegram chat using MTProto (Telethon). The Bot API cannot read chat history — this skill uses the user API instead.

## Setup

### 1. Install Telethon
```bash
pip3 install telethon
```

### 2. Get API credentials
Go to https://my.telegram.org/apps and create an app. Save credentials in the skill directory:
```bash
cat > <skill-dir>/api_credentials.json << 'EOF'
{"api_id": YOUR_API_ID, "api_hash": "YOUR_API_HASH"}
EOF
```

### 3. Login (one-time)

All paths below are relative to the skill directory.

```bash
# Step 1: Request a login code (sent to your Telegram app)
python3 scripts/login.py send +1234567890

# Output: Code sent! phone_code_hash: abc123
# Output: Run: python3 login.py verify +1234567890 <code> abc123

# Step 2: Verify with the code you received
# IMPORTANT: Do NOT send the code via Telegram — Telegram detects shared codes and blocks login.
# Use a file, another messenger, or run the command directly in terminal.
python3 scripts/login.py verify +1234567890 <CODE> <PHONE_CODE_HASH>

# If 2FA is enabled, append your password:
python3 scripts/login.py verify +1234567890 <CODE> <PHONE_CODE_HASH> <2FA_PASSWORD>

# Check login status:
python3 scripts/login.py check +1234567890
```

Session persists in `session/` — no need to re-login after initial setup.

## Usage

```bash
# Fetch last 50 messages from a chat
python3 scripts/tg_history.py history <chat_id> --limit 50

# Fetch from a forum topic
python3 scripts/tg_history.py history <chat_id> --topic <topic_id> --limit 30

# JSON output
python3 scripts/tg_history.py history <chat_id> --json

# Paginate (messages before a specific ID)
python3 scripts/tg_history.py history <chat_id> --offset-id <msg_id> --limit 50
```

## Notes

- Group chat IDs use `-100` prefix (e.g., `-1001234567890`)
- Forum topic IDs = the thread/topic message ID
- Sender names are resolved automatically
- All paths (session, credentials) are resolved relative to the skill directory — works regardless of install location
