#!/bin/bash
# Telebiz MCP Service Manager
# Keeps telebiz-mcp running persistently for browser connection

LOG_FILE="$HOME/.telebiz-mcp.log"
PID_FILE="$HOME/.telebiz-mcp.pid"

start() {
    if [ -f "$PID_FILE" ] && kill -0 "$(cat $PID_FILE)" 2>/dev/null; then
        echo "Already running (PID $(cat $PID_FILE))"
        return 0
    fi
    
    echo "Starting telebiz-mcp..."
    nohup telebiz-mcp >> "$LOG_FILE" 2>&1 &
    echo $! > "$PID_FILE"
    echo "Started (PID $!)"
    echo "Waiting for browser to connect..."
    
    # Wait up to 30 seconds for browser
    for i in {1..30}; do
        sleep 1
        if grep -q "Loaded.*tools" "$LOG_FILE" 2>/dev/null; then
            TOOLS=$(grep "Loaded.*tools" "$LOG_FILE" | tail -1 | grep -oP '\d+(?= tools)')
            echo "✅ Browser connected with $TOOLS tools"
            return 0
        fi
    done
    
    echo "⚠️ Browser not connected yet. Make sure telebiz.io is open."
    return 1
}

stop() {
    if [ -f "$PID_FILE" ]; then
        PID=$(cat "$PID_FILE")
        if kill -0 "$PID" 2>/dev/null; then
            kill "$PID"
            echo "Stopped (PID $PID)"
        fi
        rm -f "$PID_FILE"
    else
        echo "Not running"
    fi
    # Also kill any strays
    pkill -f "telebiz-mcp" 2>/dev/null
}

status() {
    if [ -f "$PID_FILE" ] && kill -0 "$(cat $PID_FILE)" 2>/dev/null; then
        PID=$(cat "$PID_FILE")
        if ss -tlnp 2>/dev/null | grep -q ":9716"; then
            if grep -q "Loaded.*tools" "$LOG_FILE" 2>/dev/null; then
                TOOLS=$(grep "Loaded.*tools" "$LOG_FILE" | tail -1 | grep -oP '\d+(?= tools)')
                echo "✅ Running (PID $PID) - Browser connected with $TOOLS tools"
                return 0
            else
                echo "🟡 Running (PID $PID) - Waiting for browser"
                return 1
            fi
        else
            echo "❌ Process exists but port not listening"
            return 2
        fi
    else
        echo "❌ Not running"
        return 2
    fi
}

restart() {
    stop
    sleep 2
    start
}

logs() {
    tail -f "$LOG_FILE"
}

case "$1" in
    start)   start ;;
    stop)    stop ;;
    status)  status ;;
    restart) restart ;;
    logs)    logs ;;
    *)
        echo "Usage: $0 {start|stop|status|restart|logs}"
        exit 1
        ;;
esac
