#!/bin/bash
# Start Telebiz HTTP MCP Server
# This keeps telebiz-mcp running persistently with HTTP API

cd "$(dirname "$0")"

# Check if already running
if curl -s http://localhost:9718/status > /dev/null 2>&1; then
    echo "Already running:"
    curl -s http://localhost:9718/status | jq .
    exit 0
fi

# Build if needed
if [ ! -f dist/http-server.js ]; then
    echo "Building..."
    npm run build
fi

echo "Starting Telebiz HTTP MCP Server..."
exec node dist/http-server.js
