# Tech Digest PDF Template

Professional PDF output with Chinese typography, emoji icons, and A4 layout.

## Generation

Generate PDF from the markdown report using `generate-pdf.py`:

```bash
python3 scripts/generate-pdf.py --input /tmp/td-report.md --output /tmp/td-digest.pdf
```

## Prerequisites

- **weasyprint**: `pip install weasyprint`
- **Chinese fonts**: `apt install fonts-noto-cjk` (Noto Sans CJK SC)

## Workflow

1. Generate the digest in **markdown format** first (same as Discord template output)
2. Save the markdown to a temp file (e.g., `/tmp/td-report.md`)
3. Run `generate-pdf.py` to convert to PDF
4. Optionally attach the PDF to Discord or email

## Features

- **A4 layout** with 2cm/2.5cm margins
- **Noto Sans CJK SC** font for native Chinese rendering
- **Emoji support** — section icons (🧠🤖💰🔬) render correctly
- **Page headers/footers** — "Tech Digest" header, page numbers
- **Blue accent color scheme** — headers, links, blockquote borders
- **Blockquote summary** — highlighted executive summary area
- **Source links** — compact, below each item
- **Responsive bullet lists** — clean indentation

## Example Markdown Input

The PDF generator accepts the same markdown format as the Discord template:

```markdown
# 🚀 科技日报 - 2026-02-25

> 今日要闻：OpenAI 发布新模型，Anthropic 推出 Claude 4...

## 🧠 LLM / 大语言模型

• **OpenAI 发布 GPT-5** — 全新推理能力突破
  <https://openai.com/blog/gpt5>

• **Anthropic Claude 4 上线** — 更强的代码能力
  <https://anthropic.com/claude-4>

## 💰 Crypto / 区块链

• **以太坊 Pectra 升级完成** — EIP-7702 正式上线
  <https://ethereum.org/pectra>

---
📊 数据源: RSS 180 | Twitter 98 | Reddit 45 | Web 20 | GitHub 15
🤖 Generated by tech-news-digest v3.9.1
```

## Delivery

```bash
# Generate PDF
python3 scripts/generate-pdf.py -i /tmp/td-report.md -o /tmp/td-digest.pdf

# Attach to Discord
# (use message tool with filePath parameter)

# Attach to email
mail -a /tmp/td-digest.pdf -s "Tech Digest" recipient@example.com < /dev/null
```
