# Tech Digest Email Template

HTML email format optimized for Gmail/Outlook rendering.

## Delivery

Send via `gog gmail send` with `--body-html` flag:
```bash
gog gmail send --to '<EMAIL>' --subject '<SUBJECT>' --body-html '<HTML_CONTENT>'
```

**Important**: Use `--body-html`, NOT `--body`. Plain text markdown will not render properly in email clients.

## Template Structure

The agent should generate an HTML email body. Use inline styles (email clients strip `<style>` blocks).

```html
<div style="max-width:640px;margin:0 auto;font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,sans-serif;color:#1a1a1a;line-height:1.6">

  <h1 style="font-size:22px;border-bottom:2px solid #e5e5e5;padding-bottom:8px">
    🐉 {{TITLE}}
  </h1>

  <!-- Optional: Executive Summary for weekly -->
  <p style="color:#555;font-size:14px;background:#f8f9fa;padding:12px;border-radius:6px">
    {{SUMMARY}}
  </p>

  <!-- Topic Section -->
  <h2 style="font-size:17px;margin-top:24px;color:#333">{{emoji}} {{label}}</h2>
  <ul style="padding-left:20px">
    <li style="margin-bottom:10px">
      <strong>🔥{{quality_score}}</strong> {{title}} — {{description}}
      <br><a href="{{link}}" style="color:#0969da;font-size:13px">{{link}}</a>
    </li>
  </ul>

  <!-- Repeat for each topic -->

  <!-- KOL Section: Read metrics from twitter JSON data (metrics.impression_count, reply_count, retweet_count, like_count). One tweet per <li>. -->
  <h2 style="font-size:17px;margin-top:24px;color:#333">📢 KOL Updates</h2>
  <ul style="padding-left:20px">
    <li style="margin-bottom:10px">
      <strong>{{display_name}}</strong> (@{{handle}}) — {{summary}}
      <br><code style="font-size:12px;color:#888;background:#f4f4f4;padding:2px 6px;border-radius:3px">👁 {{views}} | 💬 {{replies}} | 🔁 {{retweets}} | ❤️ {{likes}}</code>
      <br><a href="{{tweet_link}}" style="color:#0969da;font-size:13px">{{tweet_link}}</a>
    </li>
  </ul>

  <!-- Twitter/X Trending Section: Each entry must include at least one reference link -->
  <h2 style="font-size:17px;margin-top:24px;color:#333">🔥 Community Buzz</h2>
  <ul style="padding-left:20px">
    <li style="margin-bottom:10px">
      <strong>{{trending_topic}}</strong> — {{summary}}
      <br><a href="{{reference_link}}" style="color:#0969da;font-size:13px">{{reference_link}}</a>
    </li>
  </ul>

  <!-- Blog / Releases sections -->

  <!-- Footer -->
  <hr style="border:none;border-top:1px solid #e5e5e5;margin:24px 0">
  <p style="font-size:12px;color:#888">
    📊 Data Sources: RSS {{rss_count}} | Twitter {{twitter_count}} | Reddit {{reddit_count}} | Web {{web_count}} | GitHub {{github_count}} releases | After dedup: {{merged_count}} articles
    <br>🤖 Generated by <a href="https://github.com/draco-agent/tech-news-digest" style="color:#0969da">tech-news-digest</a> v{{version}} | Powered by <a href="https://openclaw.ai" style="color:#0969da">OpenClaw</a>
  </p>

</div>
```

## Style Guidelines

- **Max width**: 640px centered (mobile-friendly)
- **Fonts**: System font stack (no web fonts in email)
- **All styles inline**: Email clients strip `<style>` tags
- **Links**: Use full URLs, styled with `color:#0969da`
- **Headings**: h1 for title (22px), h2 for topics (17px)
- **Lists**: `<ul>` with `<li>`, adequate spacing
- **Footer**: Small gray text with stats
- **No images**: Pure text/HTML for maximum compatibility
- **No tables for layout**: Use div + inline styles

## Example Output

```html
<div style="max-width:640px;margin:0 auto;font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,sans-serif;color:#1a1a1a;line-height:1.6">

  <h1 style="font-size:22px;border-bottom:2px solid #e5e5e5;padding-bottom:8px">
    🐉 Daily Tech Digest — 2026-02-15
  </h1>

  <h2 style="font-size:17px;margin-top:24px;color:#333">🧠 LLM / Large Models</h2>
  <ul style="padding-left:20px">
    <li style="margin-bottom:10px">
      <strong>GPT-5.2 achieves first theoretical physics discovery</strong> — Collaboration with IAS, Cambridge, Harvard on gluon interactions
      <br><a href="https://twitter.com/OpenAI/status/2022390096625078389" style="color:#0969da;font-size:13px">twitter.com/OpenAI</a>
    </li>
    <li style="margin-bottom:10px">
      <strong>ByteDance releases Doubao 2.0</strong> — Full upgrade across Agent, image, and video
      <br><a href="https://www.jiqizhixin.com/articles/2026-02-14-9" style="color:#0969da;font-size:13px">jiqizhixin.com</a>
    </li>
    <li style="margin-bottom:10px">
      <strong>Dario Amodei: nearing the end of exponential growth</strong> — In-depth Anthropic CEO interview
      <br><a href="https://www.dwarkesh.com/p/dario-amodei-2" style="color:#0969da;font-size:13px">dwarkesh.com</a>
    </li>
  </ul>

  <h2 style="font-size:17px;margin-top:24px;color:#333">🤖 AI Agent</h2>
  <ul style="padding-left:20px">
    <li style="margin-bottom:10px">
      <strong>Stanford AI Town startup raises $100M</strong> — Backed by Fei-Fei Li, Karpathy
      <br><a href="https://www.qbitai.com/2026/02/380347.html" style="color:#0969da;font-size:13px">qbitai.com</a>
    </li>
  </ul>

  <h2 style="font-size:17px;margin-top:24px;color:#333">💰 Cryptocurrency</h2>
  <ul style="padding-left:20px">
    <li style="margin-bottom:10px">
      <strong>X to launch crypto & stock trading</strong> — Smart Cashtags feature coming soon
      <br><a href="https://www.theblock.co/post/389952" style="color:#0969da;font-size:13px">theblock.co</a>
    </li>
  </ul>

  <hr style="border:none;border-top:1px solid #e5e5e5;margin:24px 0">
  <p style="font-size:12px;color:#888">
    📊 Data Sources: RSS 287 | Twitter 71 | Reddit 45 | Web 60 | GitHub 29 releases | After dedup: 140 articles
    <br>Generated by Tech News Digest
  </p>

</div>
```
