# Tech Digest Discord Template

Discord-optimized format with bullet points and link suppression.

## Template Structure

```markdown
# 🚀 Tech Digest - {{DATE}}

{{#topics}}
## {{emoji}} {{label}}

{{#articles}}
• 🔥{{quality_score}} | {{title}}
  <{{link}}>
  {{#multi_source}}*[{{source_count}} sources]*{{/multi_source}}

{{/articles}}
{{/topics}}

---
📊 Data Sources: RSS {{rss_count}} | Twitter {{twitter_count}} | Reddit {{reddit_count}} | Web {{web_count}} | GitHub {{github_count}} releases + {{trending_count}} trending | After dedup: {{merged_count}} articles
🤖 Generated by tech-news-digest v{{version}} | <https://github.com/draco-agent/tech-news-digest> | Powered by OpenClaw
```

## Delivery

- **Default: Channel** — Send to the Discord channel specified by `DISCORD_CHANNEL_ID`
- Use `message` tool with `target` set to the channel ID for channel delivery
- For DM delivery instead, set `target` to a user ID

## Discord-Specific Features

- **Link suppression**: Wrap links in `<>` to prevent embeds
- **Bullet format**: Use `•` for clean mobile display  
- **No tables**: Discord mobile doesn't handle markdown tables well
- **Emoji headers**: Visual hierarchy with topic emojis
- **Concise metadata**: Source count and multi-source indicators
- **Character limits**: Discord messages have 2000 char limit, may need splitting

## Example Output

```markdown
# 🚀 Tech Digest - 2026-02-15

## 🧠 LLM / Large Models

• 🔥15 | OpenAI releases GPT-5 with breakthrough reasoning capabilities
  <https://openai.com/blog/gpt5-announcement>
  *[3 sources]*

• 🔥12 | Meta's Llama 3.1 achieves new MMLU benchmarks
  <https://ai.meta.com/blog/llama-31-release>

## 🤖 AI Agent

• 🔥14 | LangChain launches production-ready agent framework
  <https://blog.langchain.dev/production-agents>

## 💰 Cryptocurrency

• 🔥18 | Bitcoin reaches new ATH at $67,000 amid ETF approval
  <https://coindesk.com/markets/btc-ath-etf>
  *[2 sources]*

## 📢 KOL Updates

• **Elon Musk** (@elonmusk) — Confirmed X's crypto trading feature `👁 2.1M | 💬 12.3K | 🔁 8.5K | ❤️ 49.8K`
  <https://twitter.com/elonmusk/status/123456789>
• **@saylor** — Valentine's BTC enthusiasm `👁 450K | 💬 1.2K | 🔁 3.1K | ❤️ 13K`
  <https://twitter.com/saylor/status/987654321>

---
📊 Data Sources: RSS 285 | Twitter 67 | Reddit 45 | Web 60 | GitHub 29 releases + 33 trending | After dedup: 95 articles
```

## Variables

- `{{DATE}}` - Report date (YYYY-MM-DD format)
- `{{topics}}` - Array of topic objects
- `{{emoji}}` - Topic emoji 
- `{{label}}` - Topic display name
- `{{articles}}` - Array of article objects per topic
- `{{title}}` - Article title (truncated if needed)
- `{{link}}` - Article URL
- `{{quality_score}}` - Article quality score (higher = more important)
- `{{multi_source}}` - Boolean, true if article from multiple sources
- `{{source_count}}` - Number of sources for this article
- `{{total_sources}}` - Total number of sources used
- `{{total_articles}}` - Total articles in digest