---
name: tencent-finance
description: Get stock prices, quotes, and compare stocks using Tencent Finance API. No API key required. Supports US stocks, China A-Shares, Hong Kong stocks. Optimized for use in mainland China.
---

# Tencent Finance CLI

A Python CLI for fetching stock data from Tencent Finance API.

## Features

- ✅ **No API key required** - 无需申请 API Key
- ✅ **Works in mainland China** - 针对中国大陆网络环境优化，直接访问腾讯财经 API
- ✅ **Fast & Stable** - 比 Yahoo Finance API 更稳定，不受限流影响
- ✅ **Multi-market support** - 支持美股、A股、港股

## Installation

```bash
chmod +x /path/to/skills/tencent-finance/tfin
ln -sf /path/to/skills/tencent-finance/tfin /usr/local/bin/tfin  # Optional: global access
```

## Commands

### Price (quick check)
```bash
tfin AAPL              # Quick price
tfin price AAPL        # Same as above
```

### Quote (detailed)
```bash
tfin quote MSFT
```

### Compare
```bash
tfin compare AAPL,MSFT,GOOGL
tfin compare TSLA,NVDA
```

### Search
```bash
tfin search "tesla"
tfin search "bitcoin"
```

### Help
```bash
tfin help
tfin --help
```

## Symbol Format

- **US stocks:** AAPL, MSFT, GOOGL, TSLA, NVDA
- **China A-Shares:** sh000001 (上证指数), sz399001 (深证成指), sh600519 (茅台)
- **Hong Kong:** hk00700 (腾讯), hk09988 (阿里), hk03690 (美团)
- **Crypto:** BTC-USD, ETH-USD

## Examples

```bash
# Quick price check
tfin AAPL
tfin TSLA

# Detailed quote
tfin quote NVDA

# Compare tech giants
tfin compare AAPL,MSFT,GOOGL,META,AMZN

# Search
tfin search "apple"
tfin search "bitcoin"

# China stocks
tfin sh000001           # 上证指数
tfin quote hk00700      # 腾讯控股
```

## Data Source

This tool uses **Tencent Finance API** (腾讯财经 API).

**Why Tencent API?**
- 在中国大陆网络环境下可直接访问，无需代理
- 比 Yahoo Finance API 更稳定，不受限流影响
- 数据覆盖美股、A股、港股等多个市场

Data includes:
- Current price (实时价格)
- Price change (absolute & percentage) (涨跌额/涨跌幅)
- Open, High, Low prices (开盘/最高/最低价)
- Previous close (昨收)
- Volume (成交量)
- Market cap (市值)
- P/E ratio (市盈率)
- P/B ratio (市净率)

## Supported Markets

| Market | Example | Status |
|--------|---------|--------|
| US Stocks | AAPL, TSLA, NVDA | ✅ Supported |
| China A-Shares | sh000001, sz399001 | ✅ Supported |
| Hong Kong | hk00700, hk09988 | ✅ Supported |
| Crypto | BTC-USD, ETH-USD | ✅ Supported |
| India NSE/BSE | RELIANCE.NS, TCS.BO | ❌ Not supported |

## Comparison with Yahoo Finance

| Feature | Yahoo Finance (yfinance) | Tencent Finance (tfin) |
|---------|--------------------------|------------------------|
| Mainland China Access | Often blocked/restricted | ✅ Direct access |
| Rate Limiting | Frequent | ✅ Stable |
| US Stocks | ✅ Supported | ✅ Supported |
| China A-Shares | Limited | ✅ Full support |
| Hong Kong Stocks | Supported | ✅ Supported |
| Indian Stocks | ✅ Supported | ❌ Not supported |
| Options/Dividends | Supported | ❌ Not supported |

## Requirements

- Python 3.7+
- requests
- rich

```bash
pip3 install requests rich
```

## Troubleshooting

### "No data found"
- Verify the symbol format
- Try with prefix: `usAAPL` instead of `AAPL`
- Some international markets may not be supported

### Connection errors
- Check internet connection
- Tencent API is optimized for mainland China and generally very stable

## License

MIT License

## Author

Created by Menrfa
