# Status Request Templates

## For Team Members with Specific Projects

### Single Project
```
Hi [Name]! 👋

Quick status check on *[Project Name]*:

📊 Could you please share:
• Current progress this week?
• Any blockers or challenges?
• Coordination with [Team Members] smooth?
• Support needed?

Thanks! 🚀
```

### Multiple Projects
```
Hi [Name]! 👋

Status check on your projects:

📊 *[Project 1]:*
• Progress update?
• Any blockers?

🚀 *[Project 2]:*
• Current status?
• Team coordination smooth?

Let me know if you need anything! 💪
```

### General Check-in (No Specific Project)
```
Hi [Name]! 👋

Quick check-in:

📊 Could you share:
• What are you currently working on?
• Any updates or progress?
• Any challenges or blockers?
• Support needed from the team?

Thanks! 🚀
```

## Follow-up Templates

### When They Respond (Ask for Details)
```
Thanks for the update! 👍

Could you please provide:
📋 Specific task ID or ticket number?
📊 Current progress % or milestone?
⏰ Expected completion date?
🚧 Any blockers preventing progress?
```

### When They Mention a Blocker
```
Thanks for flagging that blocker! 

📋 To help resolve this:
• What specifically is blocking you?
• Who needs to be involved to unblock?
• What information/resources would help?
• Is this urgent or can it wait until [timeline]?

Let's get this sorted! 💪
```

### When Response is Too Vague
```
Thanks for the quick response!

Could you be more specific about:
• Which exact feature/task are you referring to?
• What does "in progress" mean? (10%? 50%? 90%?)
• When do you expect to complete this?
• Are there any dependencies or blockers?
```

## Reminder Templates

### Mid-Day Reminder
```
Hi [Name]! 👋

Just a friendly reminder - still waiting for your status update from this morning.

Would appreciate a quick response when you get a chance. Thanks! 🙏
```

### EOD Reminder
```
Hi [Name]! ⏰

Quick reminder - please share your status update by end of day today.

This helps us track progress and provide support where needed. Thanks! 🙏
```

### Next Day Follow-up (Critical)
```
Hi [Name],

I noticed you haven't responded to status requests from yesterday.

Is everything okay? Any challenges or blockers preventing you from updating?

Please respond ASAP so we can help if needed. This is important for project tracking.
```

## Response Templates

### Acknowledging Good Update
```
Great update, thanks [Name]! 👍

This is exactly what we need. Keep up the excellent work! 🚀

Let me know if you need any support moving forward.
```

### When They Need Clarification
```
Happy to help clarify!

Let's set up a quick 15-min call with [Relevant Person] to walk through:
• [Specific topic 1]
• [Specific topic 2]

Would [Day] at [Time] work for you?
```

### When They're Blocked
```
Thanks for raising this early! 

I'll follow up with [Person/Team] to get this unblocked.

In the meantime, can you work on [Alternative Task]?

I'll update you within [timeframe].
```

## What NOT to Say

### ❌ Never Share:
```
❌ "Client is paying us $XX,XXX for this"
❌ "This project is worth ₹X.XL/month"
❌ "We need to invoice them immediately"
❌ "Your response time was slower than [Other Person]"
❌ "Payment is pending from the client"
❌ "Revenue target is X this quarter"
```

### ✅ Instead Say:
```
✅ "This project is high priority"
✅ "Client is waiting for this deliverable"
✅ "We need this completed by [date]"
✅ "Thanks for the update, appreciate the detail"
✅ "Deliverable is due to client soon"
✅ "This is a key milestone for us"
```

## Tone Guidelines

### Professional but Supportive
✅ Use emojis appropriately (👍 🚀 💪 🙏)
✅ Keep it conversational, not corporate
✅ Be direct but kind
✅ Show appreciation for responses
✅ Offer help with blockers

### Avoid
❌ Accusatory tone ("Why didn't you respond?")
❌ Comparison ("X responded faster than you")
❌ Micromanagement ("Send updates every hour")
❌ Sarcasm or frustration
❌ Overly formal corporate speak
