# Obsidian Daily Status Tracking Template

## File Structure

```
/root/life/pkm/daily-status/
├── README.md (confidentiality rules)
├── YYYY-MM-DD/
│   ├── TEAM STATUS - YYYY-MM-DD.md
│   └── SUMMARY.md
└── [future dates...]
```

## README.md Template

```markdown
# Daily Team Status Tracking

## ⚠️ CONFIDENTIAL - INTERNAL USE ONLY

**CRITICAL RULES:**
1. ❌ NEVER share commercial/financial/payment information with resources
2. ❌ NEVER share these tracking notes with team members
3. ❌ NEVER discuss individual performance metrics publicly
4. ✅ Only share with founder or when explicitly authorized

## Information Classification

### 🚫 NEVER Share with Resources:
- Payment amounts, invoicing details
- Client billing information
- Revenue figures, profit margins
- Commercial terms and contracts
- Performance comparisons
- These behavioral tracking notes
- Response time metrics
- Non-responder lists

### ✅ CAN Share (When Appropriate):
- Project requirements
- Task assignments
- Team coordination
- General project status
- Technical support

Last Updated: YYYY-MM-DD
Access Level: CONFIDENTIAL - FOUNDER ONLY
```

## Daily Status Template

```markdown
# Team Status Tracking - [Date]

**Status Request Sent:** HH:MM UTC
**Tracking Period:** [Date]

---

## Response Summary

### ✅ Responded (X/Y)
1. **Name** - Response time: Xh Xm

### ⏳ Pending Response (X/Y)
1. Name
2. Name

---

## Individual Status Notes

### 1. [Team Member Name] ([Project/Role])
- **Response Time:** Xh Xm (PROMPT/DELAYED/NONE)
- **Response Quality:** Detailed/Good/Vague/Minimal
- **Status:** [What they reported]
- **Blockers:** [Any blockers mentioned]
- **Team Coordination:** [How team work is going]
- **Support Needed:** [What they need]
- **Follow-up Action:** [What you asked for]
- **Behavioral Note:** [Pattern observation]

### 2. [Next Team Member]
...

---

## Key Observations

### Response Rate
- **Total:** X/Y (Z%)
- **Quick Responders:** Name, Name
- **Non-Responders:** Name, Name

### Behavioral Patterns
- ✅ **Positive:** [Good patterns]
- ⚠️ **Concern:** [Issues noticed]
- 🚨 **Critical:** [Urgent issues]

### Action Items
1. ✅ [Completed action]
2. ⏳ [Pending action]
3. 🔴 [Urgent action needed]

---

## Next Steps

### Immediate (Today)
- [ ] Monitor responses throughout day
- [ ] Update tracking as responses come
- [ ] Follow up with responders for details

### EOD Actions (if no response)
- [ ] Document non-responders
- [ ] Consider 1-on-1 for critical roles
- [ ] Review communication approach

---

**CONFIDENTIAL - INTERNAL USE ONLY**
**DO NOT SHARE WITH TEAM MEMBERS**

Last Updated: YYYY-MM-DD HH:MM UTC
```

## Summary Template

```markdown
# Daily Status Summary - [Date]

## Actions Completed ✅

### 1. Slack Communication
- ✅ Sent personalized status requests (HH:MM UTC)
- ✅ Checked responses (HH:MM UTC)
- ✅ Responded to X people
- ✅ Sent EOD reminders to X people

### 2. Responses Received
**Name (Project):**
- Response time: Xh Xm
- Status: [Brief summary]
- Follow-up: [What you asked]
- ✅ NO commercial info shared

## Current Status

### Response Rate: X/Y (Z%)

**✅ Responded (X):**
1. Name - Xh Xm (PROMPT/DELAYED)
2. Name - Xh Xm

**⏳ Awaiting Response (X):**
1. Name ⚠️ (Role/importance)
2. Name

## Key Observations

### ✅ Positive
- [Good patterns observed]

### ⚠️ Concerns
- [Issues or delays]

### 🚨 Critical
- [Urgent matters]

## Next Actions

### Throughout Today
- [ ] Monitor Slack for responses
- [ ] Update tracking document
- [ ] Ask for task IDs from responders
- [ ] NO commercial info in responses

### End of Day
- [ ] Final response summary
- [ ] Flag persistent non-responders
- [ ] Plan 1-on-1 if needed
- [ ] Review communication effectiveness

---

**Files Created:**
1. `/path/to/TEAM STATUS - [DATE].md`
2. `/path/to/SUMMARY.md`

**Last Updated:** YYYY-MM-DD HH:MM UTC
```

## Response Quality Assessment

### Excellent (Detailed)
- Specific task IDs mentioned
- Progress percentages or milestones
- Clear timeline provided
- Blockers identified with context
- Asks clarifying questions

**Example:**
```
"Working on Task #123 (User Authentication). 
Currently 70% complete - finished login flow, 
working on password reset. Will complete by 
Friday EOD. Blocked on API keys from DevOps, 
pinged them this morning."
```

### Good (Clear)
- General progress mentioned
- Some specifics provided
- Timeline mentioned
- Responds to main questions

**Example:**
```
"Making good progress on authentication module. 
Should be done by end of week. No major blockers, 
coordinating well with backend team."
```

### Vague (Needs Follow-up)
- Generic status
- No specifics
- No timeline
- Missing key info

**Example:**
```
"Working on it, making progress."
```

### Minimal (Poor)
- One-word responses
- No useful information
- Dismissive

**Example:**
```
"Yes" or "Going fine"
```

## Behavioral Pattern Examples

### 🟢 Proactive (Excellent)
- Responds < 1 hour
- Detailed updates without prompting
- Mentions blockers early
- Asks for help when needed
- Regular communication

### 🟡 Reactive (Acceptable)
- Responds 3-6 hours (same day)
- Provides info when asked
- Needs follow-up for details
- Adequate but not proactive

### 🔴 Non-Responsive (Poor)
- Responds > 12 hours or not at all
- Vague responses
- Multiple reminders needed
- Communication issues

---

**Note:** Update these templates based on your team's specific needs and communication patterns.
