# Problem Resolution — Taxi

## Common Issues & Solutions

### 1. Overcharged / Wrong Fare

**Symptoms:**
- Fare higher than estimate
- Charged for trip not taken
- Double charged
- Charged after cancellation

**Resolution Steps:**
1. Screenshot receipt and estimate
2. Open app → Trip history → Select trip
3. "Help" or "Report issue"
4. Select "Fare review" or "I was overcharged"
5. Provide details: expected fare, actual fare, reason
6. Wait 24-48h for review

**Escalation if denied:**
- Reply to email explaining discrepancy
- Tweet @Uber_Support or @AskLyft (public pressure)
- Credit card dispute as last resort (may get account banned)

### 2. Driver Took Long Route

**Evidence needed:**
- Google Maps showing optimal route
- Trip receipt showing route taken
- Time stamps

**Resolution:**
1. Report in app immediately
2. Select "Driver took poor route"
3. Attach evidence
4. Usually partial refund offered

### 3. Lost Item

**Immediate Actions:**
1. Check if driver still nearby (call through app)
2. Report lost item in app ASAP
3. Provide detailed description
4. Offer finder's fee ($15-20 typical)

**By Platform:**

| Platform | Lost Item Process |
|----------|-------------------|
| Uber | App → Your Trips → Lost Item → Contact driver |
| Lyft | App → Ride History → Get Help → Lost Item |
| Taxi | Call company dispatch, provide trip details |

**Tips:**
- Act within 24 hours (drivers clean cars)
- Be specific: "Black iPhone 14 Pro in case, left in back seat right side"
- Check Found items if driver returned to hub

### 4. Safety Concern

**During Ride:**
- Use in-app emergency button
- Share trip with trusted contact
- Call 911 if immediate danger
- DO NOT confront driver

**After Ride:**
- Report in app immediately
- Be specific about concern
- Platform investigates all safety reports
- May result in driver suspension

**Serious Incidents:**
1. Document everything
2. File police report if applicable
3. Report to platform
4. Consider legal consultation
5. Contact local regulator (TLC in NYC, etc.)

### 5. Driver No-Show / Wrong Location

**Prevention:**
- Verify pickup pin is correct
- Use address, not "My Location"
- Note landmark for driver
- Check driver is actually moving toward you

**Resolution:**
- Wait full timer (usually 5 min)
- Contact driver through app
- Cancel and request refund
- "Driver never arrived" gets fee waived

### 6. Cancellation Fee Dispute

**Valid reasons for waiver:**
- Driver was >5 min late to estimated arrival
- Driver asked you to cancel
- Driver went wrong direction
- Vehicle didn't match (safety)

**Request process:**
1. Trip history → Select cancelled trip
2. "Dispute cancellation fee"
3. Explain situation
4. Usually automatic refund for valid cases

### 7. Rating Issues

**Driver rated you poorly:**
- Can't see who rated what
- Focus on improving: ready at pickup, polite, no mess
- Some platforms let you see average rating trend

**You want to change your rating:**
- Uber: Can change within 30 days
- Lyft: Can change within 24 hours
- Trip history → Rate again

### 8. Account Issues

| Problem | Solution |
|---------|----------|
| Account suspended | Contact support, ask for specific reason |
| Payment declined | Update card, try different method |
| Phone verification loop | Clear app data, try web version |
| Hacked account | Change password, check trip history, contact support |
| Banned from platform | Usually permanent, can try formal appeal |

### 9. Billing Disputes

**Wrong Payment Method:**
- Contact support to switch charge
- Update default payment in settings

**Duplicate Charges:**
- Screenshot both charges
- Report in app or email
- Usually resolved within 5-7 business days
- Credit card dispute if platform unresponsive

**Business vs Personal:**
- Some apps let you switch after ride
- Others require support intervention
- Keep receipts for manual reimbursement

## Escalation Paths

### Level 1: In-App Support
- First try for all issues
- Response: 24-48 hours typical
- Resolution rate: ~70%

### Level 2: Email Support
- support@uber.com
- help@lyft.com
- Include trip ID, date, detailed description
- Response: 48-72 hours

### Level 3: Social Media
- @Uber_Support on Twitter/X
- @AskLyft on Twitter/X
- Public posts get faster response
- Be factual, not emotional

### Level 4: Executive Escalation
- Find executive email pattern (firstname@company.com)
- CEO/COO/Head of Customer Experience
- Use for serious unresolved issues only
- Be professional and specific

### Level 5: External

| Channel | When to Use |
|---------|-------------|
| BBB complaint | Repeated ignored issues |
| Local regulator (TLC, PUC) | Safety, licensing issues |
| Credit card dispute | Unauthorized charges, fraud |
| Small claims court | Significant damages |
| Media | Egregious safety/privacy violations |

## Documentation Template

When reporting issues, include:
```
Trip Date: YYYY-MM-DD
Trip ID: [from receipt]
Pickup: [address]
Destination: [address]
Expected Fare: $XX
Charged: $XX
Issue: [clear description]
Evidence: [attachments]
Desired Resolution: [specific ask]
```

## Prevention Checklist

Before ride:
- [ ] Verify pickup location accurate
- [ ] Note driver name, photo, plate
- [ ] Share trip with contact
- [ ] Check vehicle matches app

During ride:
- [ ] Verify driver takes reasonable route
- [ ] Keep valuables with you
- [ ] Note if anything concerning

After ride:
- [ ] Check belongings before exiting
- [ ] Rate driver promptly
- [ ] Review charge matches estimate
- [ ] Report issues immediately

## Platform-Specific Notes

### Uber
- Uber Care for disability/accessibility issues
- 24/7 phone support for active safety issues
- Trip insurance for some incidents

### Lyft
- Critical Response Line for emergencies
- Lyft Pink members get priority support
- Insurance claims through Lyft claims portal

### Traditional Taxi
- Medallion/license number for complaints
- Local taxi commission handles disputes
- Cash payments harder to dispute
