# City Coverage — Taxi

## Global App Matrix

| App | Regions | Best For | Notes |
|-----|---------|----------|-------|
| Uber | 70+ countries | Coverage | Most widespread |
| Lyft | US, Canada | Price competition | US-focused |
| Bolt | 45+ countries | Budget | Often 10-20% cheaper |
| Grab | Southeast Asia | Regional | Super-app with food, pay |
| DiDi | China, LatAm, ANZ | China essential | Only option in mainland |
| Cabify | Spain, LatAm | Spanish markets | Premium feel |
| Careem | MENA, Pakistan | Middle East | Uber-owned |
| Gojek | Indonesia, SG, VN | Indonesia | Multi-service |
| Ola | India, UK, ANZ | India price war | Competes with Uber |
| FREE NOW | Europe | Taxi aggregation | Ex-mytaxi |
| Yandex Go | Russia, CIS, Israel | Russia essential | Also food delivery |
| Kakao T | South Korea | Korea essential | Integrated with Kakao ecosystem |
| inDriver | Global | Negotiable fares | User sets price, driver accepts |

## Region Deep Dive

### North America

**United States**
- Primary: Uber, Lyft (compare both always)
- NYC: Yellow cabs competitive short trips, Curb app for taxis
- Vegas: Use hotel taxi stands, rideshare pickup zones
- SF: Heavy regulation, compare Uber/Lyft/Via
- LA: Uber/Lyft dominate, check for promotions
- Miami: Add Ztrip for taxis

**Canada**
- Primary: Uber, Lyft (major cities)
- Quebec: Check provincial regulations
- Toronto: Beck Taxi app as alternative

**Mexico**
- Primary: Uber, DiDi, Cabify
- DiDi often cheapest
- Mexico City: Consider Uber vs metro for some routes
- Beach towns: Limited coverage, hotel shuttles common

### Europe

**Western Europe**
- Primary: Uber, Bolt, FREE NOW
- UK: Uber dominant, Bolt growing fast
- Spain: Cabify strong, Uber restricted some cities
- France: Uber, Bolt, Kapten
- Germany: FREE NOW, Uber limited, taxi apps (mytaxi legacy)
- Italy: Uber Black only in some cities, IT Taxi app
- Netherlands: Uber strong, Bolt available

**Nordic**
- Bolt strong across region
- Uber available major cities
- High prices, consider public transit

**Eastern Europe**
- Bolt: best coverage and usually cheapest
- Uber: major capitals
- Yandex: available some areas

### Asia

**China** (CRITICAL)
- DiDi ONLY - Uber doesn't operate
- Download DiDi app BEFORE arrival
- Can link international cards
- Chinese language helpful but English mode exists

**Japan**
- Uber limited (mostly UberTaxi)
- Japan Taxi app - main option
- S.RIDE in Tokyo
- Taxis reliable but expensive
- Train often better for city travel

**South Korea**
- Kakao T essential
- Uber available but Kakao dominates
- Tada (premium)

**Southeast Asia**
- Grab dominates (SG, MY, TH, PH, VN, ID)
- Indonesia: Gojek competes with Grab
- Vietnam: Grab, Be (local)
- Download Grab before arrival

**India**
- Uber and Ola compete aggressively
- Ola often cheaper
- Auto-rickshaws: Uber Auto, Ola Auto
- Traffic: budget 2x Google Maps time

**Middle East**
- UAE: Careem, Uber both work
- Saudi: Careem preferred
- Dubai: RTA taxis also excellent

### Latin America

**Brazil**
- 99 (DiDi-owned) vs Uber
- 99 often cheaper
- inDriver for negotiable fares
- Safety: prefer tracked rides at night

**Argentina**
- Cabify main option
- Uber regulatory issues (works but gray area)
- BA taxis still common

**Colombia**
- Uber, DiDi, Beat
- inDriver popular for budget

**Chile**
- Uber, Cabify, Beat
- Santiago well-covered

### Africa

**South Africa**
- Bolt: most widespread and cheapest
- Uber: available major cities
- Safety: track all rides, verify driver

**Nigeria, Kenya, Ghana**
- Bolt strong presence
- Uber in major cities
- Verify coverage before arrival

**Egypt**
- Careem, Uber both operate
- Careem often preferred locally

### Oceania

**Australia**
- Uber dominant
- DiDi, Ola competing
- 13cabs app for taxis
- Compare all three major apps

**New Zealand**
- Uber, Ola
- Zoomy (local)

## No/Limited Coverage Areas

- Cuba (no major apps)
- North Korea (no apps)
- Rural areas globally (limited to none)
- Some island nations (verify before travel)
- Sanctioned countries (varies by app)

## Pre-Travel Checklist

1. Download relevant apps BEFORE departure
2. Verify account works (payment method active)
3. Check local phone/data requirements
4. Know airport pickup rules for destination
5. Have backup payment method (cash in local currency)
6. Screenshot important addresses (if no data)
