# Booking Workflows — Taxi

## What Agent Can Do

### Full Automation (no user needed)
- Search promo codes
- Compare prices across apps
- Calculate arrival time
- Check surge status
- Monitor price drops
- Set reminders for booking window
- Pre-research destinations (pickup zones, traffic)
- Draft booking details

### Browser-Assisted (agent drives, user confirms)
- Open ride.uber.com or similar web interfaces
- Fill pickup and destination
- Select vehicle type
- Apply promo code
- Navigate to payment screen
- **User clicks final confirm**

### User Required
- Final payment confirmation
- Phone verification (new account)
- Adding new payment method
- Resolving security challenges

## Booking Flow by Platform

### Uber (Web)
```
1. ride.uber.com
2. Sign in (user if needed)
3. Enter pickup address
4. Enter destination
5. Select ride type (UberX, Comfort, Black, etc.)
6. Check fare estimate
7. Apply promo code if available
8. Request ride → USER CONFIRMS
```

### Lyft (Web)
```
1. lyft.com/rider
2. Sign in
3. Enter addresses
4. Select ride type
5. Check estimate
6. Add promo → USER CONFIRMS
```

### Bolt (Web/App)
```
1. bolt.eu or app
2. Location access or manual entry
3. Enter destination
4. Compare ride options
5. Apply promo → USER CONFIRMS
```

### Traditional Taxi (Phone/App)
- Many cities have taxi apps (Curb, Arro, etc.)
- Hotel concierge can call
- Taxi stands at airports, hotels, stations
- Phone dispatch (agent can provide number)

## Scheduling Rides

### When to Schedule
| Scenario | Schedule? | Why |
|----------|-----------|-----|
| 5 AM airport | Yes | Guaranteed, no surge |
| Morning meeting | Yes | Peace of mind |
| After dinner | Maybe | If restaurant known, yes |
| Concert/event | No | Unpredictable end time |
| Airport arrival | Yes | With flight tracking |

### Scheduling Tips
- Book 15-30 min before needed (buffer)
- Use flight tracking for arrivals (Uber/Lyft adjust)
- Set agent reminder to check booking status
- Have backup plan if schedule fails

## Special Bookings

### Airport Transfers
1. Check airport pickup rules
2. Find designated rideshare zone
3. Compare: rideshare vs taxi vs shuttle vs car service
4. For arrivals: link flight number for tracking
5. Consider: Meet & greet services for VIP

### Large Groups (5+)
Options:
- Multiple standard cars
- UberXL / Lyft XL (6 passengers)
- Uber Van / SUV
- Shuttle service
- Minibus charter

Cost comparison:
```
6 people, 20km:
- 2x UberX: ~$50-60 total
- 1x UberXL: ~$45-55 total
- Shuttle: ~$40-50 total (but slower)
```

### Business/VIP
- Uber Black / Lyft Lux
- Local car services (Blacklane, Carmel)
- Hotel car service
- Chauffeur services

### Accessibility
- Uber WAV (wheelchair accessible)
- Lyft Access
- Local paratransit services
- Advance booking often required
- Verify vehicle type before confirming

### With Children
- Car seat requirements vary by jurisdiction
- Uber Car Seat (limited markets)
- Some drivers carry seats (not guaranteed)
- BYO seat often best option
- Check local law for age/weight requirements

### With Pets
- Uber Pet (extra fee, $3-6)
- Standard rides: driver discretion
- Service animals: always allowed (ADA)
- Use carrier for small pets
- Alert driver before pickup

## Multi-Stop Rides

### When Useful
- Pickup friends along the way
- Multiple errands
- Drop someone off then continue

### Booking
- Uber: Add stop (up to 2 extra)
- Lyft: Add stops
- Pricing: time + distance, stops may add wait fee
- Tip: Enter all stops upfront for accurate estimate

## Corporate Booking

### Uber for Business
- Admin portal: business.uber.com
- Employee profiles
- Expense policies
- Centralized billing
- Travel program integration

### Lyft Business
- Similar features
- Concierge mode (book for others)
- Guest rides

### Setting Up
1. Create business account
2. Add payment method
3. Invite employees
4. Set travel policies
5. Configure expense integration

## Car Service / Chauffeur

For premium needs:
- Blacklane (global)
- Carmel (US)
- Sixt ride (Europe)
- Local limo services

When to use:
- VIP client pickup
- Wedding transportation
- Extended day hire
- Privacy needed
- Specific vehicle required

Booking:
- Often 24h+ advance
- Fixed pricing common
- Meet & greet included
- Flight tracking standard
