# TaxClaw — Terms of Use

**Last updated:** February 22, 2026  
**Effective date:** February 22, 2026  
**Publisher:** Outbranch Network LLC, a New York limited liability company  
**Contact:** lando@outbranch.net

---

> ⚠️ **IMPORTANT:** These Terms of Use constitute a legally binding agreement between you and Outbranch Network LLC. By downloading, installing, or using TaxClaw, you agree to be bound by these Terms. If you do not agree, do not use TaxClaw.

---

## 1. What TaxClaw Is — and Is Not

**TaxClaw is a data extraction tool.**

TaxClaw reads fields printed on your tax documents (W-2, 1099 variants, K-1, brokerage statements, and similar forms) and organizes that data into a structured local database for your review and export.

**TaxClaw is NOT:**
- A tax preparation service
- A tax return filing service
- A source of tax advice, legal advice, accounting advice, or financial advice
- An IRS-authorized e-file provider
- A CPA firm, law firm, enrolled agent service, or credentialed tax service of any kind

**TaxClaw does NOT:**
- Prepare or file tax returns on your behalf
- Interpret tax items or tell you how to treat any item on your return
- Compute cost basis
- Verify the accuracy of data printed on your source documents
- Guarantee that extracted values are correct, complete, or usable for any purpose

Use of TaxClaw does not create any professional, fiduciary, advisory, or attorney-client relationship between you and Outbranch Network LLC.

**For tax advice, consult a qualified tax professional** — a CPA, Enrolled Agent, or licensed tax attorney.

---

## 2. AI Accuracy Disclaimer — Your Responsibility

TaxClaw uses artificial intelligence (AI) to extract data fields from tax documents. **AI extraction is imperfect and may produce errors, omissions, transpositions, or misreadings of your source documents.**

**YOU ARE SOLELY RESPONSIBLE FOR:**

- Verifying every extracted value against your original source documents before using that data for any purpose
- The accuracy of any tax return you file with the IRS or any state taxing authority
- Any tax, penalty, interest, or professional costs resulting from errors in data you relied upon
- Determining whether extracted data is suitable for your intended use

Outbranch Network LLC makes **no representation or warranty, express or implied**, regarding the accuracy, completeness, or fitness for any particular purpose of data extracted by TaxClaw.

---

## 3. Limitation of Liability — Liability Cap

**TO THE MAXIMUM EXTENT PERMITTED BY APPLICABLE LAW:**

IN NO EVENT SHALL OUTBRANCH NETWORK LLC, ITS MEMBERS, OFFICERS, EMPLOYEES, CONTRACTORS, OR AFFILIATES BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, CONSEQUENTIAL, EXEMPLARY, OR PUNITIVE DAMAGES ARISING FROM YOUR USE OF TAXCLAW OR RELIANCE ON ANY DATA EXTRACTED BY TAXCLAW, INCLUDING BUT NOT LIMITED TO:

- Tax penalties, interest, or underpayment assessments
- IRS audit costs or professional representation fees
- Lost refunds or missed deductions resulting from extraction errors
- Any consequential financial harm

**EVEN IF OUTBRANCH NETWORK LLC HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.**

**TOTAL LIABILITY CAP:**

Outbranch Network LLC's total maximum liability to you for any and all claims arising from your use of TaxClaw shall not exceed:

- **$0 (zero dollars)** — if you are using TaxClaw under the free/MIT open-source tier at no charge
- **The amount actually paid by you** — if you are a Pro tier subscriber, limited to the total fees paid to Outbranch Network LLC in the twelve (12) months immediately preceding the claim, regardless of the then-current Pro tier price

These caps are essential terms of these Terms of Use. If you do not accept them, do not use TaxClaw.

---

## 4. No Warranty — "As Is"

TAXCLAW IS PROVIDED **"AS IS"** AND **"AS AVAILABLE"** WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED.

OUTBRANCH NETWORK LLC EXPRESSLY DISCLAIMS ALL WARRANTIES, INCLUDING BUT NOT LIMITED TO:

- Warranties of merchantability
- Fitness for a particular purpose
- Non-infringement
- Accuracy or completeness of extracted data
- Uninterrupted or error-free operation
- Compatibility with your operating system or hardware

You use TaxClaw entirely at your own risk.

---

## 5. Prohibited Uses

You may not use TaxClaw to:

1. Process tax documents belonging to other people without their explicit written authorization
2. Provide tax preparation services to third parties for compensation using TaxClaw output as the primary data source, without independently verifying all extracted values
3. Resell, sublicense, or white-label TaxClaw Pro tier features without a separate commercial license from Outbranch Network LLC
4. Attempt to reverse-engineer, decompile, or extract the source code of TaxClaw Pro proprietary components
5. Use TaxClaw in violation of any applicable law, including IRS regulations, state tax law, or data protection law
6. Transmit malicious content through TaxClaw's upload functionality
7. Misrepresent TaxClaw as a licensed tax preparation service to any third party
8. Remove, obscure, or alter any disclaimer, copyright notice, or legal notice in TaxClaw's interface or output files

---

## 6. License

**Free/Core Tier:** TaxClaw's core functionality is released under the MIT License. The MIT License text is available in the LICENSE file in the TaxClaw repository.

**Pro Tier:** TaxClaw Pro features are proprietary and are NOT covered by the MIT License. Pro features are licensed for your personal use only under the terms delivered with your Pro license. Unauthorized copying, redistribution, or modification of Pro-tier code or binaries is prohibited.

**MIT does not waive these Terms:** Even for the MIT-licensed core, you agree to these Terms of Use when you use TaxClaw. The MIT License governs redistribution of source code; these Terms of Use govern your use of TaxClaw as a software application.

---

## 7. Open Source and Third-Party Components

TaxClaw incorporates open-source libraries and components. Their licenses are listed in the repository's dependency files. Outbranch Network LLC is not responsible for defects in third-party components.

---

## 8. Privacy

Your use of TaxClaw is also governed by TaxClaw's [Privacy Policy](/privacy). The Privacy Policy is incorporated into these Terms by reference.

---

## 9. Modifications to These Terms

Outbranch Network LLC may update these Terms of Use at any time. Updated Terms will be posted within the TaxClaw application and on the TaxClaw GitHub repository. Continued use of TaxClaw after Terms are updated constitutes acceptance of the updated Terms.

---

## 10. Governing Law; Dispute Resolution

These Terms of Use are governed by and construed in accordance with the laws of the **State of New York**, without regard to conflict-of-law principles.

Any dispute arising from these Terms or your use of TaxClaw shall be resolved in the state or federal courts located in **New York County, New York**. You consent to personal jurisdiction in those courts.

**Limitation Period:** Any claim arising from these Terms must be brought within **one (1) year** of the event giving rise to the claim, or it is permanently barred.

---

## 11. Severability; Entire Agreement

If any provision of these Terms is found unenforceable, the remaining provisions remain in full force. These Terms, together with the Privacy Policy, constitute the entire agreement between you and Outbranch Network LLC regarding TaxClaw.

---

## 12. Contact

Questions about these Terms:

**Outbranch Network LLC**  
Email: lando@outbranch.net  
GitHub: https://github.com/DougButdorf/TaxClaw

---

*⚠️ Attorney review recommended before public launch. These Terms were drafted by an AI legal advisor (Mon Coase / Outbranch Network) and have not been reviewed by a licensed attorney. Budget 2–4 hours of attorney review time before launch.*
