---
name: tax-planning
description: Plan and manage taxes effectively as a solopreneur to minimize liability and avoid penalties. Use when understanding tax obligations, quarterly estimated taxes, deductions, S-Corp election, or year-end tax strategy. Covers tax basics by entity type, estimated tax payments, deduction optimization, and when to hire a CPA. Not professional tax advice — consult a CPA for your specific situation. Trigger on "taxes", "tax planning", "quarterly taxes", "tax deductions", "S-Corp", "tax strategy", "estimated taxes", "reduce taxes".
---

# Tax Planning

## Overview
Taxes are one of the biggest expenses for solopreneurs. Without planning, you'll overpay or face penalties. With planning, you can legally minimize your tax burden and keep more of what you earn. This playbook covers tax fundamentals, quarterly payments, deductions, and strategic decisions like S-Corp election. **Disclaimer: This is educational content, not professional tax advice. Consult a CPA for your specific situation.**

---

## Step 1: Understand Your Tax Obligations (U.S.)

As a solopreneur, you pay multiple types of taxes. Know what you owe.

**Tax types:**

| Tax Type | What It Is | Rate | When You Pay |
|---|---|---|---|
| **Income Tax** | Federal tax on profit | 10-37% (marginal brackets) | Quarterly estimated + April 15 |
| **Self-Employment Tax** | Social Security + Medicare | 15.3% on net earnings | Quarterly estimated + April 15 |
| **State Income Tax** | State tax on profit (if applicable) | 0-13% (varies by state) | Quarterly estimated + state deadline |
| **Sales Tax** (if selling physical goods) | Tax on sales to customers | Varies by state | Monthly or quarterly |

**Total effective tax rate for solopreneurs:** 25-40% of profit (depending on income level and state).

**Example:**
```
Net Profit: $100,000
Federal Income Tax (~22%): $22,000
Self-Employment Tax (15.3%): $15,300
State Income Tax (~5%): $5,000
Total Tax: $42,300 (42% effective rate)
```

**Rule:** Set aside 30% of every payment you receive for taxes. Transfer it to a separate savings account immediately.

---

## Step 2: Make Quarterly Estimated Tax Payments

If you're self-employed, you don't have an employer withholding taxes. You must pay quarterly.

**Quarterly tax deadlines (U.S.):**
- Q1: April 15
- Q2: June 15
- Q3: September 15
- Q4: January 15 (following year)

**How much to pay each quarter:**
```
Estimated Annual Profit × Effective Tax Rate / 4
```

Example:
```
Expected profit: $100,000
Effective rate: 30%
Quarterly payment: $100,000 × 0.30 / 4 = $7,500
```

**How to pay:**
- Federal: IRS Direct Pay (irs.gov/payments) or EFTPS
- State: Your state's tax website

**Penalties for not paying quarterly:**
- IRS charges underpayment penalties (~5-6% annually on what you owe)
- Safe harbor rule: If you pay 100% of last year's tax liability (110% if income > $150K), you avoid penalties even if you underpay this year

**Rule:** Pay quarterly even if it's an estimate. Better to overpay slightly and get a refund than underpay and face penalties.

---

## Step 3: Maximize Your Tax Deductions

Deductions reduce your taxable income. More deductions = less tax owed.

**Top deductions for solopreneurs (U.S.):**

### 1. Home Office Deduction
If you have a dedicated space for business, you can deduct a portion of rent/mortgage, utilities, insurance.

**Two methods:**
- **Simplified:** $5/sq ft (max 300 sq ft = $1,500/year)
- **Actual expenses:** (Home office sq ft / Total home sq ft) × Total home expenses

Example:
```
Office: 150 sq ft
Home: 1,500 sq ft
Home expenses (rent + utilities): $24,000/year
Deduction: (150/1,500) × $24,000 = $2,400
```

**Requirements:**
- Space must be used EXCLUSIVELY for business (no dual-purpose rooms)
- Must be your principal place of business

### 2. Business Equipment and Supplies
- Computers, monitors, desks, chairs
- Software subscriptions (Notion, Adobe, hosting, domain)
- Office supplies (pens, paper, printer)

**Section 179 deduction:** Deduct full cost of equipment in year purchased (up to ~$1M), rather than depreciating over years.

### 3. Vehicle and Mileage
If you drive for business (client meetings, site visits, errands):
- **Standard mileage rate:** $0.67/mile (2024 rate — check current year)
- **Actual expenses:** Track gas, maintenance, insurance, depreciation (complex, requires detailed records)

**Recommendation:** Use standard mileage (simpler). Track with app (MileIQ, Everlance).

**Not deductible:** Commuting from home to office.

### 4. Professional Services
- CPA / tax preparation fees
- Lawyer fees (contracts, legal advice)
- Business consultants or coaches

### 5. Marketing and Advertising
- Paid ads (Google, Facebook, LinkedIn)
- Website costs (hosting, domain, design)
- Content creation (copywriters, designers, video editors)

### 6. Business Travel and Meals
- **Travel:** 100% deductible (flights, hotels for business trips)
- **Meals:** 50% deductible (business meals with clients or networking)

**Rule:** Keep receipts and note the business purpose.

### 7. Education and Training
- Courses, books, conferences related to your business
- Must improve skills for current business (not for entering a new field)

### 8. Contractor and Employee Payments
- Payments to contractors (if you issue 1099s)
- Payroll expenses (if you have employees)

### 9. Health Insurance (if self-employed)
- 100% of health insurance premiums deductible (for you and family)
- Deducted on personal return (Form 1040), not business return

### 10. Retirement Contributions
- Solo 401(k): Contribute up to $23,000 (2024 limit) + 25% of net earnings (total max ~$69,000)
- SEP-IRA: Contribute up to 25% of net earnings (max ~$69,000)

**Why this matters:** Reduces taxable income AND builds retirement savings.

---

## Step 4: Decide If You Should Elect S-Corp Status

If your profit is > $80-100K/year, S-Corp election can save you thousands on self-employment tax.

**How S-Corp saves money:**

As a sole proprietor or default LLC, you pay 15.3% self-employment tax on ALL profit.

As an S-Corp, you:
1. Pay yourself a "reasonable salary" (subject to payroll taxes)
2. Take remaining profit as "distributions" (NOT subject to self-employment tax)

**Example:**
```
Profit: $150,000

DEFAULT LLC:
  Self-employment tax: $150,000 × 15.3% = $22,950

S-CORP:
  Reasonable salary: $80,000
  Self-employment tax on salary: $80,000 × 15.3% = $12,240
  Distributions (no self-employment tax): $70,000
  Total self-employment tax: $12,240
  
SAVINGS: $22,950 - $12,240 = $10,710/year
```

**S-Corp downsides:**
- Requires payroll setup (payroll provider ~$500-1,500/year)
- More paperwork (payroll taxes, quarterly filings)
- Must pay yourself a "reasonable salary" (can't pay $20K salary on $150K profit — IRS will challenge it)

**When to elect S-Corp:**
- Profit > $80-100K/year (savings outweigh the extra costs)
- You're willing to run payroll

**When NOT to elect S-Corp:**
- Profit < $60K/year (savings too small to justify extra work)
- You're just starting out (wait until profit is consistent)

**How to elect:** File Form 2553 with IRS. Must be done by March 15 of the year you want it to take effect (or within 75 days of forming your LLC).

**Rule:** Talk to a CPA before electing S-Corp. They'll help you determine if it's worth it and set up payroll.

---

## Step 5: Year-End Tax Planning (October-December)

The last 3 months of the year are critical for tax planning.

**Year-end tax checklist:**

### October: Project Your Tax Liability
- [ ] Calculate expected profit for the year (revenue - expenses so far + projected Q4)
- [ ] Estimate total tax owed (federal + state + self-employment)
- [ ] Check if you've paid enough in quarterly taxes
- [ ] If underpaid, make a larger Q4 payment (Jan 15 deadline)

### November: Accelerate Deductions (if profitable)
If you're having a profitable year and want to reduce taxes:
- [ ] Buy equipment or software you were planning to buy in January (deduct in current year)
- [ ] Pay annual subscriptions early (if you're cash-method taxpayer)
- [ ] Make retirement contributions (Solo 401k or SEP-IRA)
- [ ] Prepay business expenses (insurance, rent) if it makes sense

**Caution:** Don't buy things you don't need just for the tax deduction. A deduction saves you 25-40% of the expense — you still spent the full amount.

### December: Defer Income (if needed)
If you're having a very high-income year and want to spread it out:
- [ ] Delay invoicing until January (so payment hits next year)
- [ ] Defer year-end bonuses or distributions until January

**When to defer:** If you're in a high tax bracket this year but expect lower income next year.

### January: File Taxes (or Hire a CPA)
- [ ] Generate P&L for the year (from accounting software)
- [ ] Compile receipts for major expenses
- [ ] Hand off to CPA, or use tax software (TurboTax, TaxAct)
- [ ] File by April 15 (or request extension to October 15)

---

## Step 6: Work with a CPA

**When to hire a CPA:**
- Revenue > $50K/year (DIY becomes risky)
- Considering S-Corp election
- Multiple income streams or complex business structure
- Audited or received an IRS notice

**What a CPA does:**
- Prepares and files your tax return
- Advises on deductions and tax strategy
- Helps with S-Corp election and payroll setup
- Represents you if audited

**Cost:** $500-2,000/year for basic tax prep. More for complex situations or year-round advisory.

**How to find a good CPA:**
- Ask other solopreneurs for referrals
- Look for CPAs who specialize in small business / self-employed
- Interview 2-3 before choosing (ask about their experience with solopreneurs)

**Red flags:**
- CPA who promises huge refunds or "too-good-to-be-true" deductions
- CPA who doesn't ask detailed questions about your business
- CPA who doesn't respond to emails/calls promptly

**Rule:** A good CPA pays for themselves in tax savings and peace of mind.

---

## Tax Planning Mistakes to Avoid
- **Not setting aside money for taxes.** Tax bills hit hard in April if you haven't saved. Set aside 30% of every payment.
- **Missing quarterly estimated tax payments.** Underpayment penalties add up. Pay quarterly even if it's an estimate.
- **Deducting personal expenses as business expenses.** IRS audits this heavily. Only deduct legitimate business expenses.
- **Not tracking mileage or receipts.** If audited, you need proof. Track everything.
- **Electing S-Corp too early.** If profit < $80K, S-Corp adds complexity without enough savings.
- **Doing your own taxes when you shouldn't.** Past $50K revenue, the risk of mistakes is too high. Hire a CPA.
