# 출력 템플릿

> 공통 Flash/Deep-Dive 구조: [`../../common/output_templates_base.md`](../../common/output_templates_base.md)

---

## Flash Layer (항상 출력, 20~40줄)

```markdown
### 💰 [세금 주제] 세금 가이드 (as of YYYY-MM-DD)
**기준:** [소득세법/부가가치세법 등] + 국세청 공식 자료

**한 줄 결론:** …

| 항목 | 내용 |
|------|------|
| 세목 | 소득세 / 부가세 / 재산세 / 증여세 등 |
| 세율 | XX% (누진세율 적용 시: XX~XX%) |
| 납부 기한 | YYYY.MM.DD |
| 신고 방법 | 홈택스 / 위택스 / 세무서 방문 |
| 절세 포인트 | 핵심 1가지 |

**절차 (해당 시)**
1. [단계] — [내용] (기한/비용)
2. …

**절세 팁 (해당 시)**
- 💡 [팁 1줄] — 절세 효과 추정액 또는 한도
- 💡 …

⚠️ 본 내용은 일반 세금 정보 제공 목적이며, 세무 자문이 아닙니다.
구체적인 사안은 세무사 또는 국세청 상담(☎126)을 받으시기 바랍니다.
```

---

## Deep-Dive Layer (요청 시 또는 주요 인텐트)

```markdown
## 1. 세금 상세 분석
### 과세 구조
- 과세 대상: …
- 세율 구간 (누진세 시):
  | 과세표준 | 세율 | 누진공제 |
  |---------|------|---------|
  | ~1,200만원 | 6% | - |
  | ~4,600만원 | 15% | 108만원 |
  | ~8,800만원 | 24% | 522만원 |
  | … | … | … |

## 2. 공제 / 감면 항목
| 항목 | 한도 | 조건 |
|------|------|------|
| … | … | … |

## 3. 계산 예시
- 소득/재산 기준: XX원
- 공제 적용 후 과세표준: XX원
- 산출세액: XX원
- 최종 납부세액: XX원 (세액공제 후)

## 4. 신고·납부 절차
| 단계 | 방법 | 기한 | 비용 |
|------|------|------|------|
| 1 | 홈택스 접속 / 세무서 방문 | | |
| 2 | 자료 입력 / 서류 제출 | | |
| 3 | 납부 | | |

## 5. 불복 / 경정청구 (세금 잘못 낸 경우)
- 경정청구 기한: 신고 후 5년 이내
- 이의신청 → 심판청구 → 행정소송 순서

## 6. 관련 법령
- [소득세법 제XX조](https://www.law.go.kr/...) — 조문 요약
- [시행령 제XX조] — 세부 기준

## Appendix
- 기준: [법령명 + 시행일]
- 계산 도구: 국세청 세금 계산기 (hometax.go.kr)
⚠️ 본 내용은 일반 세금 정보 제공 목적이며, 세무 자문이 아닙니다.
```

---

## 인텐트별 특화 템플릿

### Year-end Settlement (연말정산) Flash 추가 항목
```markdown
**주요 공제 항목 체크리스트**
- [ ] 인적공제 (본인/배우자/부양가족)
- [ ] 보험료 (건강보험료 등)
- [ ] 의료비 (총급여 3% 초과분)
- [ ] 교육비 (취학 전 아동~대학생)
- [ ] 주택 관련 (전세자금 대출이자, 청약저축)
- [ ] 기부금
- [ ] IRP / 연금저축 (최대 900만원, 세액공제 16.5%)
- [ ] 신용카드/체크카드 (총급여 25% 초과 사용분)
```

### Tax Deduction (절세) Flash 추가 항목
```markdown
**절세 수단 효과 비교**
| 수단 | 한도 | 세액공제율 | 최대 절세액 |
|------|------|-----------|------------|
| IRP | 900만원 | 16.5% | 148만원 |
| 연금저축 | 600만원 | 16.5% | 99만원 |
| ISA | 200만원 비과세 | - | - |
| 청약저축 | 300만원 | 40% | 120만원 |
```

### Property Tax (보유세) Flash 추가 항목
```markdown
**납부 일정**
| 세목 | 납부 시기 | 기준 |
|------|---------|------|
| 재산세 (1기) | 7월 31일 | 건물분 |
| 재산세 (2기) | 9월 30일 | 토지분 |
| 종합부동산세 | 12월 15일 | 공시가 합산 |
```

---

## 초보자 모드 용어 설명 (자동 적용)

`domain_config.yaml > beginner_mode > glossary` 참조.

첫 등장 시 괄호로 쉬운 설명:
```
"연말정산(1년 동안 미리 낸 세금을 연말에 정확히 계산해 돌려주거나 추가납부하는 것)"
"세액공제(계산된 세금 자체를 직접 깎아주는 것. 소득공제보다 절세 효과 큼)"
"종합소득세(1년 동안 번 모든 소득을 합산해서 5월에 신고·납부하는 세금)"
```
