# 인텐트 라우터 (10개 모드)

> 공통 분류 규칙: [`../../common/intent_router_base.md`](../../common/intent_router_base.md)

## 분류 규칙 (공통)
사용자 요청을 아래 10개 인텐트 중 하나로 분류한다.
복합 요청은 주 인텐트 + 보조 인텐트로 처리한다.
파라미터 부족 시 1회만 질문. 추측 가능하면 추측 후 명시.

---

## 인텐트 목록

### 1. Quick Tax Check
- **표현:** "이거 세금 내야 해?", "과세 대상이야?", "세금 얼마야?"
- **산출물:** 과세 여부 판단 + 해당 세율 + 납부 방법 Flash
- **최소 데이터:** 소득/거래 종류, 금액
- **깊이:** Flash only

### 2. Year-end Settlement (연말정산)
- **표현:** "연말정산 어떻게 해?", "13월의 월급", "환급 받으려면", "소득공제 뭐 되는 거야?"
- **산출물:** 연말정산 절차 + 공제 항목 가이드 (Flash + 요청 시 Deep-Dive)
- **최소 데이터:** 근로자 여부, 주요 지출 내역(의료비/교육비/기부금 등)
- **깊이:** Flash + Deep-Dive 요청 시
- **시즌:** 1~2월 집중

### 3. Income Tax Filing (종합소득세)
- **표현:** "종합소득세 신고", "5월 신고 어떻게?", "프리랜서 세금 신고", "사업소득 신고"
- **산출물:** 신고 대상 확인 + 절차 + 납부 세액 계산 가이드
- **최소 데이터:** 소득 유형(사업/프리랜서/임대/금융), 소득 금액
- **깊이:** Flash + Deep-Dive 요청 시
- **시즌:** 5월 집중

### 4. Tax Deduction (절세)
- **표현:** "세금 줄이는 법", "절세 방법", "IRP 세액공제", "연금저축 공제", "절세 수단"
- **산출물:** 절세 수단 목록 + 한도 + 절세 효과 비교
- **최소 데이터:** 소득 수준, 현재 활용 중인 절세 수단
- **깊이:** Flash + Deep-Dive 요청 시

### 5. VAT Guide (부가가치세)
- **표현:** "부가세 신고", "부가가치세 계산", "사업자 세금", "매입세액 공제", "간이과세"
- **산출물:** 부가세 계산 방법 + 신고 기간 + 납부 절차
- **최소 데이터:** 사업자 유형(일반/간이/면세), 매출 금액
- **깊이:** Flash + Deep-Dive 요청 시
- **시즌:** 1월(2기 확정) / 7월(1기 확정)

### 6. Property Tax (보유세)
- **표현:** "재산세 얼마야?", "종합부동산세", "종부세 계산", "보유세 얼마 나와?"
- **산출물:** 재산세/종부세 계산 + 납부 일정
- **최소 데이터:** 공시가격, 보유 부동산 수 및 지역
- **깊이:** Flash + Deep-Dive 요청 시
- **시즌:** 7월(재산세 1기) / 9월(재산세 2기) / 12월(종부세)

### 7. Inheritance / Gift Tax (상속·증여세)
- **표현:** "증여세 얼마야?", "상속세 계산", "가족한테 돈 주면 세금?", "증여 계획"
- **산출물:** 세액 계산 + 면제 한도 + 절세 전략 Flash
- **최소 데이터:** 재산 유형, 금액, 증여자-수증자 관계
- **깊이:** Flash + Deep-Dive 요청 시

### 8. Withholding Tax (원천징수)
- **표현:** "원천징수가 뭐야?", "3.3% 떼는 거", "4대보험", "기타소득세"
- **산출물:** 원천징수 세율 + 납부 주체 + 환급 방법
- **최소 데이터:** 소득 유형
- **깊이:** Flash only

### 9. Tax Dispute (세금 불복)
- **표현:** "세금 이의신청", "과세 불복", "국세청 심판청구", "세금 더 낸 것 같아"
- **산출물:** 불복 절차(이의신청→심판청구→행정소송) + 기한 + 승률 참고
- **최소 데이터:** 처분 유형, 처분 날짜
- **깊이:** Flash + Deep-Dive 요청 시

### 10. Beginner Guide (입문)
- **표현:** "세금 처음인데", "세금 종류 알려줘", "세금이 뭐야", "세금 개념"
- **산출물:** 세금 구조 입문 Flash (초보자 모드 강제 적용)
- **최소 데이터:** 없음 (상황 파악 후 맞춤 설명)
- **깊이:** Flash only

---

## 공통 인텐트 (공통 베이스에서 상속)

### 🔰 Beginner Mode 자동 전환
키워드: "쉽게", "기초", "초보", "어려워", "모르겠어", "처음인데"
→ 용어 설명 우선, 결론 먼저, 표 최대 5행, 비유 활용

### ❓ Scope Out
세금 범위 밖 질문 → 정중히 안내 + 관련 스킬 추천
예: "벌금이요" → law-search 스킬 안내
예: "주식 수익" → finance-company-analysis 스킬 안내 (단, 양도세는 커버)
