# 세금 가이드 플레이북

> 공통 Phase 구조: [`../common/playbook_base.md`](../common/playbook_base.md)

---

## Phase 1: 인텐트 분류 & 파라미터 확인

1. 사용자 요청을 [`references/intent_router.md`](references/intent_router.md)로 분류
2. **초보자 모드 감지**: "쉽게", "기초", "초보", "어려워", "처음인데" 키워드 확인
3. 필수 파라미터:
   - **세목**: 소득세 / 부가세 / 재산세 / 증여세 / 원천징수 등
   - **금액**: 소득 / 재산 / 거래 금액
   - **상황**: 근로자 / 사업자 / 프리랜서 / 개인
4. 파라미터 부족 시: 1회 질문
   ```
   예: "어떤 세금 궁금하세요? (소득세/부가세/재산세/증여세 등)"
   예: "근로소득이세요, 사업소득이세요?"
   ```

---

## Phase 2: 데이터 수집

### 2-1. 법령 조문 조회 (1차)
```bash
# law-search 스킬 활용
bash skills/law-search/scripts/law_search.sh "소득세법" 5
bash skills/law-search/scripts/law_search.sh "부가가치세법" 5
bash skills/law-search/scripts/law_search.sh "상속세 및 증여세법" 5
```

### 2-2. 세목별 핵심 조문
| 세목 | 주요 법령 | 핵심 조문 |
|------|---------|---------|
| 소득세(근로) | 소득세법 | 제47조(근로소득공제), 제59조(세액공제) |
| 소득세(종합) | 소득세법 | 제70조(신고), 제55조(세율) |
| 부가가치세 | 부가가치세법 | 제49조(확정신고), 제39조(매입세액) |
| 재산세 | 지방세법 | 제110조(과세표준), 제111조(세율) |
| 종합부동산세 | 종합부동산세법 | 제8조(과세표준), 제9조(세율) |
| 증여세 | 상속세 및 증여세법 | 제53조(증여재산공제), 제56조(세율) |
| 상속세 | 상속세 및 증여세법 | 제18조(기초공제), 제26조(세율) |

### 2-3. 웹 검색 보강 (2차)
```
web_search: "국세청 [세목] [연도] 신고 방법"
web_search: "국세청 [세목] 세율 [연도]"
web_search: "홈택스 [세목] 신고 기간"
```

### 2-4. 국세청 고정 지식 (API 없음 → 내장 지식 활용)
- 세율표: 아래 "세율 레퍼런스" 참조
- 공제 한도: domain_config.yaml glossary + 아래 참조
- 신고 기간: 아래 "시즌 달력" 참조

---

## Phase 3: 분석

### 세율 레퍼런스 (2025년 기준)

**종합소득세 세율 (소득세법 제55조)**
| 과세표준 | 세율 | 누진공제 |
|---------|------|---------|
| 1,400만원 이하 | 6% | - |
| 5,000만원 이하 | 15% | 126만원 |
| 8,800만원 이하 | 24% | 576만원 |
| 1억5천만원 이하 | 35% | 1,544만원 |
| 3억원 이하 | 38% | 1,994만원 |
| 5억원 이하 | 40% | 2,594만원 |
| 10억원 이하 | 42% | 3,594만원 |
| 10억원 초과 | 45% | 6,594만원 |

**증여세 세율 (상속세 및 증여세법 제56조, 상속세 동일)**
| 과세표준 | 세율 | 누진공제 |
|---------|------|---------|
| 1억원 이하 | 10% | - |
| 5억원 이하 | 20% | 1,000만원 |
| 10억원 이하 | 30% | 6,000만원 |
| 30억원 이하 | 40% | 1억6,000만원 |
| 30억원 초과 | 50% | 4억6,000만원 |

**증여재산공제 (10년 합산)**
| 관계 | 공제 한도 |
|------|---------|
| 배우자 | 6억원 |
| 직계존속 (부모→자녀) | 5,000만원 (미성년 2,000만원) |
| 직계비속 (자녀→부모) | 5,000만원 |
| 기타 친족 | 1,000만원 |

**부가가치세 세율**
- 일반과세자: 매출세액(10%) - 매입세액 = 납부세액
- 간이과세자: 매출액 × 업종별 부가가치율 × 10%
- 면세사업자: 부가세 없음 (의료, 교육, 농산물 등)

### 시즌 달력

| 월 | 세금 이벤트 |
|----|-----------|
| 1월 | 부가세 2기 확정신고 (1.1~1.25) |
| 1~2월 | 연말정산 간소화 서비스 (1.15~) |
| 3월 | 법인세 신고 |
| 5월 | 종합소득세 신고 (5.1~5.31) |
| 7월 | 부가세 1기 확정신고 (7.1~7.25), 재산세 1기 (7.16~7.31) |
| 9월 | 재산세 2기 (9.16~9.30) |
| 11~12월 | 종합부동산세 (12.1~12.15) |

---

## Phase 4: 출력

[`references/output_templates.md`](references/output_templates.md) 템플릿 적용:
- **Flash Layer**: 항상 출력
- **Deep-Dive Layer**: 명시적 요청 시, 또는 Year-end Settlement / Income Tax / Tax Dispute 인텐트

### 면책 문구 (모든 응답 필수)
> ⚠️ 본 내용은 일반 세금 정보 제공 목적이며, 세무 자문이 아닙니다.
> 구체적인 사안은 세무사 또는 국세청 상담(☎126)을 받으시기 바랍니다.
