# Filing Status Decision Tree

## Part A: Filer Type (Citizen vs. Resident Alien vs. NRA)

### US Citizen
- Born in the US, or
- Naturalized citizen, or
- Born abroad to US citizen parent(s)
→ **Resident**. File Form 1040.

### Green Card Holder
- Lawful permanent resident at any point during the tax year
→ **Resident**. File Form 1040.
- Note: Even if the green card was surrendered mid-year, you may be a resident for the full year or a dual-status filer.

### Visa Holder — Apply the Substantial Presence Test (SPT)

**Step 1: Check exempt individual status.**
Exempt individuals do NOT count their days toward the SPT:
- F-1 / J-1 **students**: exempt for first **5 calendar years** in the US
- J-1 **teachers/researchers**: exempt for first **2 calendar years**
- Diplomats (A/G visas): exempt indefinitely

If exempt → **NRA** for the exempt period. File Form 1040-NR.

**Step 2: Count days (non-exempt individuals only).**

```
SPT total = (days in current year × 1)
          + (days in 1st prior year × 1/3)
          + (days in 2nd prior year × 1/6)
```

- If SPT total ≥ 183 → **Resident alien**. File Form 1040.
- If SPT total < 183 → **NRA**. File Form 1040-NR.

**Step 3: Closer Connection Exception.**
Even if SPT ≥ 183, you may still be treated as NRA if:
- You were present < 183 days in the current year, AND
- You maintained a tax home in a foreign country, AND
- You had a closer connection to that country
- Must file Form 8840 to claim this exception.

### Dual-Status Filers
If residency status changed mid-year (e.g., F-1 student who became H-1B mid-year and passed SPT):
- File Form 1040 as a dual-status return
- Attach a statement for the NRA portion of the year
- Cannot use standard deduction (must itemize)
- Cannot file MFJ (unless electing to treat NRA spouse as resident for the full year)
- This is a complex case — flag it for the user and suggest professional review

### First-Year Election (IRC §7701(b)(4))
An NRA who doesn't meet SPT can elect to be treated as a resident from a specific date if:
- They were present ≥ 31 consecutive days in the election year, AND
- They were present ≥ 75% of days from the start of that 31-day period through year-end
- Must be a resident in the following year

This is uncommon but comes up when someone arrives mid-year on H-1B.

## Part B: Filing Status (for Form 1040 Filers)

Once determined to be a resident (citizen or RA), choose filing status:

### Single
- Unmarried on Dec 31 of the tax year, OR
- Legally separated under a divorce decree

### Married Filing Jointly (MFJ)
- Married on Dec 31 and both spouses agree to file together
- Generally the most favorable tax brackets and deductions
- Both spouses are jointly liable for the tax

### Married Filing Separately (MFS)
- Married but choosing to file separate returns
- Usually results in higher tax — but useful when:
  - One spouse has significant medical expenses (7.5% AGI floor is lower with lower individual AGI)
  - Income-driven student loan repayment (lower AGI = lower payment)
  - You don't want to be liable for spouse's tax

### Head of Household (HOH)
- Unmarried (or considered unmarried) on Dec 31, AND
- Paid more than half the cost of keeping up a home, AND
- A qualifying person lived with you for more than half the year
- Better brackets than Single; larger standard deduction ($22,500 for 2025)

### Qualifying Surviving Spouse (QSS)
- Spouse died in one of the two prior tax years
- You have a dependent child
- You paid more than half the cost of maintaining the home
- Gets the same standard deduction and brackets as MFJ

## Quick Reference: 2025 Standard Deductions

| Filing Status | Standard Deduction |
|--------------|-------------------|
| Single | $15,000 |
| MFJ | $30,000 |
| MFS | $15,000 |
| HOH | $22,500 |
| QSS | $30,000 |

Add $2,000 if age 65+ or blind (per qualifying condition).
