#!/usr/bin/env bash
set -euo pipefail

limit="${1:-10}"

response=$(curl -s "$TAUTULLI_URL/api/v2?apikey=$TAUTULLI_API_KEY&cmd=get_recently_added&count=$limit")

echo "$response" | jq -r '.response.data.recently_added[] | "\(.title) (\(.year // "N/A")) - \(.library_name) - added \(.added_at | tonumber | strftime("%Y-%m-%d"))"'
