#!/usr/bin/env bash
set -euo pipefail

limit="${1:-10}"

response=$(curl -s "$TAUTULLI_URL/api/v2?apikey=$TAUTULLI_API_KEY&cmd=get_history&length=$limit")

echo "$response" | jq -r '.response.data.data[] | "\(.friendly_name // .user) watched \(.full_title // .title) (\(.started | tonumber | strftime("%Y-%m-%d %H:%M")))"'
