---
name: tautulli
description: Monitor Plex activity and stats via Tautulli API. Check who's watching, view history, get library stats, and see server info.
metadata:
  openclaw:
    emoji: 📊
    requires:
      bins:
        - curl
        - jq
      env:
        - TAUTULLI_URL
        - TAUTULLI_API_KEY
---

# Tautulli

Monitor Plex Media Server activity via Tautulli API.

## Setup

Set environment variables:
- `TAUTULLI_URL` – Tautulli instance URL (e.g., `http://192.168.1.100:8181`)
- `TAUTULLI_API_KEY` – Settings → Web Interface → API Key

## Commands

### Current Activity

```bash
bash {baseDir}/scripts/activity.sh
```

Shows active streams with user, title, progress, quality, and player.

### Watch History

```bash
bash {baseDir}/scripts/history.sh [limit]
```

Default: last 10 items. Pass a number for more.

### Library Stats

```bash
bash {baseDir}/scripts/libraries.sh
```

Lists library sections with item counts.

### Recently Added

```bash
bash {baseDir}/scripts/recent.sh [limit]
```

Shows recently added media. Default: 10 items.

### User Stats

```bash
bash {baseDir}/scripts/users.sh
```

Lists users with total watch time and last seen date.

### Server Info

```bash
bash {baseDir}/scripts/server.sh
```

Shows Plex server name, version, platform, and connection status.

## API Reference

All Tautulli API calls use:

```
$TAUTULLI_URL/api/v2?apikey=$TAUTULLI_API_KEY&cmd=<command>
```

Common commands: `get_activity`, `get_history`, `get_libraries`, `get_recently_added`, `get_users`, `get_server_info`.
