# Tautulli Skill for OpenClaw

Monitor your Plex Media Server via [Tautulli](https://tautulli.com/) API.

## Features

- **Current activity** – See who's watching and what
- **Watch history** – Review recent plays
- **Library stats** – Item counts per library
- **Recently added** – New media in Plex
- **User stats** – Watch time by user
- **Server info** – Plex server status

## Installation

```bash
clawhub install tautulli
```

Or clone directly:

```bash
git clone https://github.com/rjmurillo/openclaw-skill-tautulli.git ~/.openclaw/workspace/skills/tautulli
```

## Configuration

Set environment variables in your OpenClaw config (`~/.openclaw/openclaw.json`):

```json
{
  "env": {
    "vars": {
      "TAUTULLI_URL": "http://192.168.1.100:8181",
      "TAUTULLI_API_KEY": "your-api-key-here"
    }
  }
}
```

Get your API key from Tautulli: **Settings → Web Interface → API Key**

## Usage Examples

Ask your OpenClaw agent:

- "Who's watching Plex?"
- "Show me Plex history"
- "What was recently added to Plex?"
- "Show library stats"

## Requirements

- [Tautulli](https://tautulli.com/) instance
- `curl` and `jq` installed
- OpenClaw configured with environment variables

## License

MIT
