# Cultural Research Framework for Tattoos

## Research Checklist

Before committing to any symbol from another culture:

### 1. Origin Research
- [ ] Trace symbol through primary sources (academic papers, museum collections)
- [ ] Identify regional variations (same symbol differs across cultures)
- [ ] Understand historical evolution (meanings shift over centuries)
- [ ] Cross-reference multiple sources (flag contradictions)

### 2. Sacred vs. Decorative Assessment

**Closed practices (require lineage/initiation):**
- Māori ta moko — earned through whakapapa (genealogy)
- Indigenous American sacred symbols — tribe-specific permissions
- Hindu religious marks — caste/spiritual significance
- Buddhist sacred geometry — some requires monk blessing

**More accessible (but still research):**
- General Polynesian patterns (not ta moko specifically)
- Japanese traditional motifs (when not mixing sacred elements)
- Celtic knotwork (open tradition)
- Many floral/nature symbols

### 3. Questions to Answer

1. Is this symbol earned/given or freely used in its origin culture?
2. Would someone from that culture be offended seeing this on an outsider?
3. Are there similar aesthetics from my own heritage?
4. Can I explain the meaning and origin if asked?
5. Have I consulted actual cultural sources (not just Pinterest)?

## Finding Alternatives

If you love an aesthetic but shouldn't use it:

1. **Identify what attracts you** — the geometry? line weight? subject matter?
2. **Research your own heritage** — find visual traditions from your background
3. **Look for universal symbols** — nature, astronomy, mathematics
4. **Commission original work** — artist creates new design inspired by (not copying) tradition

## Red Flags in "Traditional" Designs

- Pinterest/Tumblr sourced with no attribution
- "Tribal" without specific cultural identification
- Sacred symbols mixed with unrelated elements
- Claims of "ancient meaning" without sources
- Gang or hate symbols disguised as cultural art

## Resources for Verification

- Museum collections (Met, British Museum, Smithsonian)
- Academic databases (JSTOR for cultural studies)
- Cultural organization websites (tribal councils, heritage foundations)
- Artist communities from that culture (not outsider interpretations)
