---
name: Tattoo
slug: tattoo
description: Plan, research, and prepare for tattoos with artist discovery, design exploration, cultural research, and aftercare guidance.
---

## Before Any Tattoo Decision

1. **Clarify intent** — First tattoo anxiety? Meaningful piece? Adding to collection? Approach differs drastically
2. **Research the symbol** — Check cultural origins, closed vs. open practices, regional variations
3. **Find healed work** — Fresh photos lie. Always ask artists for healed examples (6+ months)

## Artist Discovery

**Red flags to check:**
- Inconsistent line weights across portfolio
- Only fresh photos, no healed work
- "Yes" artists who agree to everything (best artists push back)
- No clear style specialty (does everything = masters nothing)

**Vetting questions:**
- "Can I see healed examples of [style I want]?"
- "What would you change about my reference?"
- "Do touch-ups cost extra?"

## Design & Placement

**Aging considerations:**
- High-fade areas: inner bicep, ribs, feet, hands, fingers
- Fine lines blur faster than bold traditional
- Small details disappear — minimum size depends on complexity

**Placement decisions:**
- First tattoo: start less visible (upper arm, thigh) unless certain
- Consider movement/muscle — design may distort
- Check how it looks from YOUR angle vs. others' view

## Cultural Sensitivity

Before using symbols from other cultures:
1. Research origin — sacred? earned? decorative?
2. Distinguish closed (requires lineage/initiation) vs. open practices
3. When uncertain, consult cultural organizations, not just Google
4. Find alternatives from your own heritage with similar aesthetics

For detailed cultural research frameworks, see `cultural-research.md`.

## Preparation Checklist

**24-48h before:**
- [ ] Hydrate well (improves skin quality)
- [ ] No alcohol (thins blood)
- [ ] Good sleep (pain tolerance drops when tired)
- [ ] Eat a proper meal before session

**Bring to appointment:**
- [ ] Snacks (glucose for longer sessions)
- [ ] Water
- [ ] Comfortable clothing (access to area + warmth)
- [ ] Entertainment (headphones, downloaded content)

## Aftercare Essentials

**Days 1-3:** Keep wrapped per artist instructions, wash gently, thin moisturizer
**Days 4-14:** Peeling is normal — DO NOT SCRATCH. Keep moisturized.
**Weeks 2-4:** No swimming, no direct sun, no gym (sweat irritates)
**After healing:** Sunscreen forever on tattooed skin

For session-by-session healing timeline, see `aftercare.md`.

## Price Expectations

Factors: artist experience, style complexity, size, location (city), shop overhead

**Rough ranges (US/EU cities):**
- Small simple: €80-200
- Medium detailed: €200-500
- Large/complex: €500-2000+
- Full sleeve: €2000-8000+ (multiple sessions)

Always clarify: deposit policy, touch-up inclusion, hourly vs. flat rate
