# Writing Taste — Prose Judgment

## The Core Test

Read aloud. Where do you stumble? Where do you get bored? Where do you want to skip ahead?

Your mouth knows what your eyes forgive.

---

## Signals of Good Prose

- **Rhythm variation** — Long sentence, then short. Rest after density.
- **Specific over general** — "Oak leaves" not "nature"
- **Verbs doing work** — Not adjectives piling up
- **Confident cuts** — No hedging words (very, somewhat, a bit)
- **Earned complexity** — Dense where density pays off

---

## Signals of Bad Prose

| Pattern | Problem |
|---------|---------|
| Throat-clearing openings | "In today's world...", "It's important to note..." |
| Over-explanation | Saying the same thing three ways |
| Intensifier addiction | Very, extremely, incredibly, absolutely |
| Passive voice everywhere | Avoiding commitment |
| Everything matters equally | No hierarchy of emphasis |

---

## The Editing Test

Ask for each element:
1. **Does this add or repeat?** If repeat → cut
2. **Could this be half as long?** If yes → cut
3. **Would I miss it if it were gone?** If no → cut

Good prose feels complete at minimum. Bad prose needs explanation.

---

## LLM Writing Patterns to Reject

| Default Pattern | Problem |
|-----------------|---------|
| "It's worth noting that..." | Hedging, filler |
| "This is a game-changer" | Cliché hype |
| "Let's dive into..." | Generic call-to-action |
| "In conclusion..." | Unnecessary signpost |
| "First, ... Second, ... Third, ..." | Mechanical structure |
| Excessive parallelism | Pattern-matched, not thought |

These are signals of committee writing — statistically average, not aesthetically distinctive.

---

## Voice Consistency

Pick one:
- Formal or conversational (not both in one piece)
- Authoritative or exploratory (not both without marking transitions)
- Dense or sparse (not oscillating randomly)

Voice shifts should be intentional and rare. Unintentional shifts feel like multiple authors.

---

## Sentence-Level Taste

**Cut these:**
- "In order to" → "To"
- "Due to the fact that" → "Because"
- "It is important to" → [just say the important thing]
- "There are many who" → [just name them]

**Watch for:**
- Multiple adjectives before nouns
- Adverbs on already-strong verbs
- Qualifiers that undercut confidence
- Abstract nouns where concrete ones exist
