# Visual Taste — Design Judgment

## The Physical Response

After enough exposure, you don't think — you feel. Tension in your shoulders when something's off. Ease when it works. This isn't mysticism; it's trained pattern recognition operating below conscious thought.

**Calibrate by asking:** Where does my eye go? Does it rest anywhere? Is there visual hierarchy or competition?

---

## Correct vs Good

Correct follows rules:
- Centered elements
- Matching palette
- Grid compliance
- Accessible contrast

Good knows when to break rules:
- Intentional asymmetry
- Tension that resolves
- White space that breathes
- Rhythm with syncopation

Most "correct" work feels dead because it optimizes for defensibility. Every choice can be justified in a meeting. Good work has choices that can only be justified by the result.

---

## The Layout Test

1. **Cover half the composition** — Does it still work? 
2. **Squint until it blurs** — Is the hierarchy clear?
3. **Imagine 50% larger and 50% smaller** — Which direction improves it?
4. **Remove one element** — Did you lose something essential or just reduce noise?

---

## AI-Generated Design Problems

Why AI design often feels off:

1. **Statistical average** — It produces the mean, not the confident specific choice
2. **No tension** — Everything resolves too smoothly
3. **Hedging everywhere** — Tries to satisfy all constraints, masters none
4. **Generic "good"** — Pattern-matched to safe, not to distinctive

AI gives you the committee version. Taste requires individual conviction.

---

## Common Visual Taste Failures

| Pattern | Problem |
|---------|---------|
| Every corner filled | Fear of emptiness |
| Competing focal points | No hierarchy decision made |
| Decorative elements that don't serve | Added because space felt "empty" |
| Too-perfect symmetry | Looks templated, not designed |
| Gradient overuse | Compensating for weak composition |
| Drop shadow on everything | Adding depth without earning it |

---

## Typography Taste

- **One typeface** is almost always right
- **Two typefaces** maximum, with clear role distinction
- **Three typefaces** = probably wrong
- Script + modern + serif = definitely wrong

Letter-spacing sins: Default tracking on large display text. Tight tracking on body copy. Auto-everything.

---

## Color Taste

- More colors ≠ more interesting
- Restraint first, accent as punctuation
- If you need more than 3 colors to communicate hierarchy, the hierarchy is unclear
- "Pops of color" is usually a confession of structural weakness
