# Developing Taste — Training Aesthetic Judgment

## The Three Requirements

1. **Volume with attention** — Not passive consumption, but interrogation
2. **Making bad work** — The gap between taste and ability is essential
3. **Studying the edges** — Near-misses teach more than masterpieces

---

## Volume With Attention

Don't just see thousands of pieces. Question them:
- Why does this work?
- What happens if I cover the bottom third?
- Where does my eye go first, second, third?
- What would make this better?
- What would ruin it?

This becomes automatic. Parsing compositions becomes like reading sentences.

---

## Making Bad Work

Your taste will exceed your ability for years. That gap is painful but essential.

**The productive discomfort:** Knowing your work is wrong before you can fix it. That tension forces vocabulary development — words for what you're sensing.

Don't avoid making things. Make things and feel the gap. The feeling is the signal.

---

## Studying the Edges

Masterpieces teach less than near-misses:
- Why does this land and that doesn't, when they're 90% identical?
- What distinguishes almost-good from actually-good?
- The answer is always in the remaining 10%

Study work that almost works. Identify what's missing. Build vocabulary for the difference.

---

## The Calibration Process

1. **Exposure to range** — See exemplary and poor, not just mediocre
2. **Deliberate comparison** — Side-by-side trains discrimination
3. **Verbal labeling** — Words create perceptual anchors
4. **Feedback loops** — Check your judgments against experts
5. **Making work** — Apply judgments to your own production

Passive consumption is insufficient. Deliberate practice is essential.

---

## Expert Convergence

Research finding: experts agree more than novices.

**Why:** Experts learn to weight the same features. They've been trained on canonical exemplars. They share vocabulary for distinctions.

**Implication:** If your judgments diverge wildly from experts, you're probably pattern-matching to wrong features. Find out what experts see that you don't.

---

## Separating Preference from Quality

The most sophisticated capability:
- "I don't like this, but it's excellent"
- "I enjoy this, but it's mediocre"

This requires metacognitive awareness: knowing when your response reflects familiarity vs craft.

**Training this:** Ask for each reaction — is this preference or evaluation? Am I responding to what it IS or how it makes me FEEL?

---

## Environmental Validity

Some domains have clearer quality signals than others:
- Design → relatively stable principles, learnable
- Writing → style-dependent but craft is detectable
- Fashion → context-dependent, faster trend cycles
- Music → genre-specific, requires domain exposure

Calibrate confidence to domain stability. Be more humble about taste in noisy domains.

---

## The Long Game

Taste develops over years, not weeks. The process:
1. Consume widely and attentively
2. Feel the gap between your taste and ability
3. Make things anyway
4. Study what experts value
5. Develop vocabulary for distinctions
6. Check your judgments against outcomes
7. Repeat for a decade

There are no shortcuts. Only accumulated exposure with engaged attention.
