# Taste Anti-Patterns — What Bad Taste Looks Like

## The Dunning-Kruger Problem

Bad taste doesn't know it's bad. It has explanations:
- "Minimalism feels lazy — where's the personality?"
- "I like things that make a statement"
- "If it catches your eye immediately, it's working"
- "More options means better value"

These are confident explanations for wrong intuitions.

---

## The "More Is Better" Family

| Manifestation | Reality |
|---------------|---------|
| "Why use one texture when you can layer three?" | Confusion ≠ richness |
| "I appreciate feature-rich designs" | Clutter ≠ value |
| "Negative space feels unfinished" | Restraint ≠ laziness |
| "It needs more visual interest" | Busy ≠ interesting |

The core error: equating quantity with quality.

---

## The "Impressive = Good" Family

| Manifestation | Reality |
|---------------|---------|
| Gold/chrome/metallic everything | Signaling luxury ≠ having taste |
| "It looks premium" | Expensive signals ≠ quality |
| Faux textures (fake marble, fake leather) | Imitation ≠ sophistication |
| "The best compliment: I've never seen anything like that" | Novelty ≠ quality |

The core error: conflating expensive signals with aesthetic excellence.

---

## The "Safe Average" Problem

Default taste gravitates toward the middle:
- Not too minimal, not too busy
- Not too bold, not too subtle
- Not too trendy, not too classic

This produces committee design — defensible, forgettable, mediocre.

Good taste often lives at extremes executed with conviction:
- Radically minimal (less than you think possible)
- Radically specific (more particular than feels safe)
- Radically restrained (one thing done perfectly)

---

## Recognition Failures

**"Anyone could make that"** — Usually said about work that required enormous restraint and judgment. Simplicity is harder than complexity.

**"It's just a white rectangle"** — Missing the proportions, the weight, the breathing room, the relationship to content.

**"There's nothing there"** — Confusing negative space with emptiness.

---

## The Trend Trap

Following trends ≠ having taste.

Trends provide:
- Social belonging
- Easy decisions
- Temporary relevance

Taste provides:
- Enduring quality recognition
- Independent judgment
- Resistance to fashion cycles

Someone dressed in full current fashion often looks more dated in 5 years than someone in simple, well-fit basics.

---

## Effort Visibility

Bad taste makes effort visible:
- You can see the Pinterest board
- You can see the three-hour getting-ready process
- You can see the anxiety about being perceived

Good taste makes choices feel inevitable:
- As if they couldn't have done anything else
- Confidence that forgets it got dressed
- Decisions that don't perform their own cleverness

---

## The Rationalization Trap

Worst pattern: reverse-engineering justifications for gut decisions.

When you already know what you want and just build arguments backward, you've stopped evaluating and started defending.

Genuine taste stays open to being wrong. Ego-driven taste defends first choices.
